/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.arrow;

import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.util.PythonUtils;
import sun.misc.Unsafe;

public class ArrowArray {
    private static final Unsafe unsafe = PythonUtils.initUnsafe();
    public static final byte[] CAPSULE_NAME = PyCapsule.capsuleName("arrow_array");
    public static final byte NULL = 0;
    private static final byte SIZE_OF = 80;
    private static final long LENGTH_INDEX = 0L;
    private static final long NULL_COUNT_INDEX = 8L;
    private static final long OFFSET_INDEX = 16L;
    private static final long N_BUFFERS_INDEX = 24L;
    private static final long N_CHILDREN_INDEX = 32L;
    private static final long BUFFERS_INDEX = 40L;
    private static final long CHILDREN_INDEX = 48L;
    private static final long DICTIONARY_INDEX = 56L;
    private static final long RELEASE_CALLBACK_INDEX = 64L;
    private static final long PRIVATE_DATA_INDEX = 72L;
    public final long memoryAddr;

    private ArrowArray(long memoryAddr) {
        this.memoryAddr = memoryAddr;
    }

    public static ArrowArray allocate() {
        ArrowArray arrowArray = new ArrowArray(unsafe.allocateMemory(80L));
        arrowArray.markReleased();
        return arrowArray;
    }

    public static ArrowArray allocateFromSnapshot(Snapshot snapshot) {
        ArrowArray arrowArray = new ArrowArray(unsafe.allocateMemory(80L));
        arrowArray.load(snapshot);
        return arrowArray;
    }

    public static ArrowArray wrap(long arrowArrayPointer) {
        return new ArrowArray(arrowArrayPointer);
    }

    public void markReleased() {
        unsafe.putLong(this.memoryAddr + 64L, 0L);
    }

    public boolean isReleased() {
        return unsafe.getLong(this.memoryAddr + 64L) == 0L;
    }

    public long getBuffers() {
        return unsafe.getLong(this.memoryAddr + 40L);
    }

    public long getValueBuffer() {
        return unsafe.getLong(this.getBuffers() + 8L);
    }

    private void load(Snapshot snapshot) {
        unsafe.putLong(this.memoryAddr + 0L, snapshot.length);
        unsafe.putLong(this.memoryAddr + 8L, snapshot.null_count);
        unsafe.putLong(this.memoryAddr + 16L, snapshot.offset);
        unsafe.putLong(this.memoryAddr + 24L, snapshot.n_buffers);
        unsafe.putLong(this.memoryAddr + 32L, snapshot.n_children);
        unsafe.putLong(this.memoryAddr + 40L, snapshot.buffers);
        unsafe.putLong(this.memoryAddr + 48L, snapshot.children);
        unsafe.putLong(this.memoryAddr + 56L, snapshot.dictionary);
        unsafe.putLong(this.memoryAddr + 64L, snapshot.release);
        unsafe.putLong(this.memoryAddr + 72L, snapshot.private_data);
    }

    public static class Snapshot {
        public long length = 0L;
        public long null_count = 0L;
        public long offset = 0L;
        public long n_buffers = 0L;
        public long n_children = 0L;
        public long buffers = 0L;
        public long children = 0L;
        public long dictionary = 0L;
        public long release = 0L;
        public long private_data = 0L;
    }
}

