/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.itertools.FilterfalseBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.PFilterfalse;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PFilterfalse})
public final class FilterfalseBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return FilterfalseBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object reduce(PFilterfalse self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile hasNoFuncProfile, @Cached GetClassNode getClassNode, @Cached PythonObjectFactory factory) {
            Object func = self.getFunc();
            if (hasNoFuncProfile.profile(inliningTarget, func == null)) {
                func = PNone.NONE;
            }
            Object type = getClassNode.execute(inliningTarget, self);
            PTuple tuple = factory.createTuple(new Object[]{func, self.getSequence()});
            return factory.createTuple(new Object[]{type, tuple});
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"hasFunc(self)"})
        static Object next(VirtualFrame frame, PFilterfalse self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached BuiltinFunctions.NextNode nextNode, @Cached CallNode callNode, @Cached.Shared @Cached PyObjectIsTrueNode isTrue, @Cached.Shared @Cached InlinedLoopConditionProfile loopConditionProfile) {
            Object n;
            do {
                n = nextNode.execute(frame, self.getSequence(), PNone.NO_VALUE);
            } while (loopConditionProfile.profile(inliningTarget, isTrue.execute((Frame)frame, inliningTarget, callNode.execute((Frame)frame, self.getFunc(), n))));
            return n;
        }

        @Specialization(guards={"!hasFunc(self)"})
        static Object nextNoFunc(VirtualFrame frame, PFilterfalse self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached BuiltinFunctions.NextNode nextNode, @Cached.Shared @Cached PyObjectIsTrueNode isTrue, @Cached.Shared @Cached InlinedLoopConditionProfile loopConditionProfile) {
            Object n;
            while (loopConditionProfile.profile(inliningTarget, isTrue.execute((Frame)frame, inliningTarget, n = nextNode.execute(frame, self.getSequence(), PNone.NO_VALUE)))) {
            }
            return n;
        }

        protected boolean hasFunc(PFilterfalse self) {
            return self.getFunc() != null;
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PFilterfalse self) {
            return self;
        }
    }
}

