/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.function;

import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;

public final class Signature {
    public static final Signature EMPTY = new Signature(-1, false, -1, false, PythonUtils.EMPTY_TRUFFLESTRING_ARRAY, PythonUtils.EMPTY_TRUFFLESTRING_ARRAY);
    private final int varArgIndex;
    private final int positionalOnlyArgIndex;
    private final boolean isVarArgsMarker;
    private final boolean takesVarKeywordArgs;
    private final boolean checkEnclosingType;
    private final boolean hidden;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final TruffleString[] positionalParameterNames;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final TruffleString[] keywordOnlyNames;
    private final TruffleString raiseErrorName;

    public Signature(boolean takesVarKeywordArgs, int takesVarArgs, boolean varArgsMarker, TruffleString[] parameterIds, TruffleString[] keywordNames) {
        this(-1, takesVarKeywordArgs, takesVarArgs, varArgsMarker, parameterIds, keywordNames);
    }

    public Signature(int positionOnlyArgIndex, boolean takesVarKeywordArgs, int takesVarArgs, boolean varArgsMarker, TruffleString[] parameterIds, TruffleString[] keywordNames) {
        this(positionOnlyArgIndex, takesVarKeywordArgs, takesVarArgs, varArgsMarker, parameterIds, keywordNames, false);
    }

    public Signature(int positionOnlyArgIndex, boolean takesVarKeywordArgs, int takesVarArgs, boolean varArgsMarker, TruffleString[] parameterIds, TruffleString[] keywordNames, boolean checkEnclosingType) {
        this(positionOnlyArgIndex, takesVarKeywordArgs, takesVarArgs, varArgsMarker, parameterIds, keywordNames, checkEnclosingType, StringLiterals.T_EMPTY_STRING);
    }

    public Signature(int positionOnlyArgIndex, boolean takesVarKeywordArgs, int takesVarArgs, boolean varArgsMarker, TruffleString[] parameterIds, TruffleString[] keywordNames, boolean checkEnclosingType, TruffleString raiseErrorName) {
        this(positionOnlyArgIndex, takesVarKeywordArgs, takesVarArgs, varArgsMarker, parameterIds, keywordNames, checkEnclosingType, raiseErrorName, false);
    }

    public Signature(int positionOnlyArgIndex, boolean takesVarKeywordArgs, int takesVarArgs, boolean varArgsMarker, TruffleString[] parameterIds, TruffleString[] keywordNames, boolean checkEnclosingType, TruffleString raiseErrorName, boolean hidden) {
        this.positionalOnlyArgIndex = positionOnlyArgIndex;
        this.takesVarKeywordArgs = takesVarKeywordArgs;
        this.varArgIndex = takesVarArgs;
        this.isVarArgsMarker = varArgsMarker;
        this.positionalParameterNames = parameterIds != null ? parameterIds : PythonUtils.EMPTY_TRUFFLESTRING_ARRAY;
        this.keywordOnlyNames = keywordNames != null ? keywordNames : PythonUtils.EMPTY_TRUFFLESTRING_ARRAY;
        this.checkEnclosingType = checkEnclosingType;
        this.raiseErrorName = raiseErrorName;
        this.hidden = hidden;
    }

    public static Signature createVarArgsAndKwArgsOnly() {
        return new Signature(-1, true, 0, false, null, null);
    }

    public int getNumOfRequiredKeywords() {
        return this.keywordOnlyNames.length;
    }

    public int getMaxNumOfPositionalArgs() {
        return this.positionalParameterNames.length;
    }

    public int getPositionalOnlyArgIndex() {
        return this.positionalOnlyArgIndex;
    }

    public int getVarargsIdx() {
        return this.varArgIndex;
    }

    public boolean takesVarArgs() {
        return this.varArgIndex != -1;
    }

    public boolean isVarArgsMarker() {
        return this.isVarArgsMarker;
    }

    public boolean takesVarKeywordArgs() {
        return this.takesVarKeywordArgs;
    }

    public TruffleString[] getParameterIds() {
        return this.positionalParameterNames;
    }

    public TruffleString[] getKeywordNames() {
        return this.keywordOnlyNames;
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString[] getVisibleKeywordNames() {
        ArrayList<TruffleString> visibleKeywordNames = new ArrayList<TruffleString>(this.keywordOnlyNames.length);
        for (TruffleString k : this.keywordOnlyNames) {
            if (k.byteLength(PythonUtils.TS_ENCODING) <= 0 || k.codePointAtByteIndexUncached(0, PythonUtils.TS_ENCODING) == 36) continue;
            visibleKeywordNames.add(k);
        }
        return (TruffleString[])visibleKeywordNames.toArray(TruffleString[]::new);
    }

    public boolean takesKeywordArgs() {
        return this.keywordOnlyNames.length > 0 || this.takesVarKeywordArgs;
    }

    public boolean takesPositionalOnly() {
        return !this.takesVarArgs() && !this.takesVarKeywordArgs && !this.isVarArgsMarker && this.keywordOnlyNames.length == 0;
    }

    public boolean takesNoArguments() {
        return this.positionalParameterNames.length == 0 && this.takesPositionalOnly();
    }

    public boolean checkEnclosingType() {
        return this.checkEnclosingType;
    }

    public TruffleString getRaiseErrorName() {
        return this.raiseErrorName;
    }

    public boolean isHidden() {
        return this.hidden;
    }
}

