/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.bytes;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.IndexNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import java.nio.ByteOrder;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=PythonBufferAccessLibrary.class)})
public final class PByteArray
extends PBytesLike {
    private volatile long exports;

    public PByteArray(Object cls, Shape instanceShape, byte[] bytes) {
        super(PythonUtils.builtinClassToType(cls), instanceShape, bytes);
    }

    public PByteArray(Object cls, Shape instanceShape, SequenceStorage store) {
        super(PythonUtils.builtinClassToType(cls), instanceShape, store);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.formatByteArray("bytearray");
    }

    @CompilerDirectives.TruffleBoundary
    public String formatByteArray(String typeName) {
        SequenceStorage sequenceStorage = this.getSequenceStorage();
        if (sequenceStorage instanceof ByteSequenceStorage) {
            ByteSequenceStorage byteSequenceStorage = (ByteSequenceStorage)sequenceStorage;
            return String.format("%s(%s)", typeName, BytesUtils.bytesRepr(byteSequenceStorage.getInternalByteArray(), byteSequenceStorage.length()));
        }
        return String.format("%s(%s)", typeName, this.getSequenceStorage());
    }

    public long getExports() {
        return this.exports;
    }

    public void setExports(long exports) {
        this.exports = exports;
    }

    public void checkCanResize(Node inliningTarget, PRaiseNode.Lazy raiseNode) {
        if (this.exports != 0L) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.BufferError, ErrorMessages.EXPORTS_CANNOT_RESIZE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isArrayElementModifiable(long index, @Cached.Exclusive @Cached IndexNodes.NormalizeIndexCustomMessageNode normalize, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            int len = this.store.length();
            try {
                normalize.execute(index, len, ErrorMessages.INDEX_OUT_OF_RANGE);
            }
            catch (PException e) {
                boolean bl = false;
                gil.release(mustRelease);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isArrayElementInsertable(long index, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            int len = this.store.length();
            boolean bl = index == (long)len;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isArrayElementRemovable(long index, @Cached.Exclusive @Cached IndexNodes.NormalizeIndexCustomMessageNode normalize, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            int len = this.store.length();
            try {
                normalize.execute(index, len, ErrorMessages.INDEX_OUT_OF_RANGE);
            }
            catch (PException e) {
                boolean bl = false;
                gil.release(mustRelease);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public void writeArrayElement(long index, Object value, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached SequenceStorageNodes.SetItemScalarNode setItem, @Cached.Exclusive @Cached PForeignToPTypeNode convert, @Cached.Exclusive @Cached GilNode gil) throws InvalidArrayIndexException {
        boolean mustRelease = gil.acquire();
        try {
            try {
                setItem.execute(inliningTarget, this.store, PInt.intValueExact(index), convert.executeConvert(value));
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw InvalidArrayIndexException.create((long)index);
            }
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public void removeArrayElement(long index, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached SequenceStorageNodes.DeleteItemNode delItem, @Cached.Exclusive @Cached GilNode gil) throws InvalidArrayIndexException {
        boolean mustRelease = gil.acquire();
        try {
            try {
                delItem.execute(inliningTarget, this.store, PInt.intValueExact(index));
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw InvalidArrayIndexException.create((long)index);
            }
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    boolean isReadonly() {
        return false;
    }

    @ExportMessage
    void writeByte(int byteOffset, byte value, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        bufferLib.writeByte(this.store, byteOffset, value);
    }

    @ExportMessage
    void writeShortByteOrder(int byteOffset, short value, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        bufferLib.writeShortByteOrder(this.store, byteOffset, value, byteOrder);
    }

    @ExportMessage
    void writeIntByteOrder(int byteOffset, int value, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        bufferLib.writeIntByteOrder(this.store, byteOffset, value, byteOrder);
    }

    @ExportMessage
    void writeLongByteOrder(int byteOffset, long value, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        bufferLib.writeLongByteOrder(this.store, byteOffset, value, byteOrder);
    }

    @ExportMessage
    void writeFloatByteOrder(int byteOffset, float value, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        bufferLib.writeFloatByteOrder(this.store, byteOffset, value, byteOrder);
    }

    @ExportMessage
    void writeDoubleByteOrder(int byteOffset, double value, ByteOrder byteOrder, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        bufferLib.writeDoubleByteOrder(this.store, byteOffset, value, byteOrder);
    }
}

