/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PySliceNew;
import com.oracle.graal.python.lib.PyTupleSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.builtins.TupleNodes;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.NativeObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

public final class PythonCextTupleBuiltins {

    static abstract class PyTuple_GetSlice
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTuple_GetSlice() {
        }

        @Specialization
        static Object getSlice(PTuple tuple, Object iLow, Object iHigh, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getItem") @Cached(value="createForTuple()") SequenceStorageNodes.GetItemNode getItemNode, @Cached.Shared(value="newSlice") @Cached PySliceNew sliceNode) {
            return PyTuple_GetSlice.doGetSlice(tuple.getSequenceStorage(), inliningTarget, iLow, iHigh, getItemNode, sliceNode);
        }

        @Specialization
        static Object doNative(PythonAbstractNativeObject tuple, Object iLow, Object iHigh, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getItem") @Cached(value="createForTuple()") SequenceStorageNodes.GetItemNode getItemNode, @Cached.Shared(value="newSlice") @Cached PySliceNew sliceNode, @Cached TupleNodes.GetNativeTupleStorage asNativeStorage) {
            return PyTuple_GetSlice.doGetSlice(asNativeStorage.execute(tuple), inliningTarget, iLow, iHigh, getItemNode, sliceNode);
        }

        @Fallback
        Object fallback(Object tuple, Object iLow, Object iHigh) {
            throw this.raiseFallback(tuple, PythonBuiltinClassType.PTuple);
        }

        private static Object doGetSlice(SequenceStorage storage, Node inliningTarget, Object iLow, Object iHigh, SequenceStorageNodes.GetItemNode getItemNode, PySliceNew sliceNode) {
            return getItemNode.execute(null, storage, sliceNode.execute(inliningTarget, iLow, iHigh, PNone.NONE));
        }
    }

    static abstract class PyTuple_Size
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTuple_Size() {
        }

        @Specialization
        public static int size(Object tuple, @Bind(value="this") Node inliningTarget, @Cached PyTupleSizeNode pyTupleSizeNode) {
            return pyTupleSizeNode.execute(inliningTarget, tuple);
        }
    }

    public static abstract class PyTruffleTuple_GetItem
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        public abstract Object execute(PTuple var1, long var2);

        @Specialization
        static Object doPTuple(PTuple tuple, long key, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="promote") @Cached PythonCextBuiltins.PromoteBorrowedValue promoteNode, @Cached SequenceStorageNodes.ListGeneralizationNode generalizationNode, @Cached.Shared @Cached SequenceStorageNodes.SetItemScalarNode setItemNode, @Cached.Shared @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            SequenceStorage sequenceStorage = tuple.getSequenceStorage();
            int index = PyTruffleTuple_GetItem.checkIndex(inliningTarget, key, sequenceStorage, raiseNode);
            Object result = getItemNode.execute(inliningTarget, sequenceStorage, index);
            assert (result != null) : "tuple must not contain Java null";
            Object promotedValue = promoteNode.execute(inliningTarget, result);
            if (promotedValue != null) {
                sequenceStorage = generalizationNode.execute(inliningTarget, sequenceStorage, promotedValue);
                tuple.setSequenceStorage(sequenceStorage);
                setItemNode.execute(inliningTarget, sequenceStorage, index, promotedValue);
                return promotedValue;
            }
            return result;
        }

        @Specialization
        static Object doNative(PythonAbstractNativeObject tuple, long key, @Bind(value="this") Node inliningTarget, @Cached TupleNodes.GetNativeTupleStorage asNativeStorage, @Cached.Shared(value="promote") @Cached PythonCextBuiltins.PromoteBorrowedValue promoteNode, @Cached.Shared @Cached SequenceStorageNodes.SetItemScalarNode setItemNode, @Cached.Shared @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            int index;
            NativeObjectSequenceStorage sequenceStorage = asNativeStorage.execute(tuple);
            Object result = getItemNode.execute(inliningTarget, sequenceStorage, index = PyTruffleTuple_GetItem.checkIndex(inliningTarget, key, sequenceStorage, raiseNode));
            Object promotedValue = promoteNode.execute(inliningTarget, result);
            if (promotedValue != null) {
                setItemNode.execute(inliningTarget, sequenceStorage, index, promotedValue);
                return promotedValue;
            }
            if (result == null) {
                return PyTruffleTuple_GetItem.getNativeNull(inliningTarget);
            }
            return result;
        }

        @Fallback
        Object fallback(Object tuple, Object pos) {
            throw this.raiseFallback(tuple, PythonBuiltinClassType.PTuple);
        }

        private static int checkIndex(Node inliningTarget, long key, SequenceStorage sequenceStorage, PRaiseNode.Lazy raiseNode) {
            if (key < 0L || key >= (long)sequenceStorage.length()) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IndexError, ErrorMessages.TUPLE_OUT_OF_BOUNDS);
            }
            return (int)key;
        }
    }

    static abstract class PyTuple_New
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTuple_New() {
        }

        @Specialization
        static PTuple doGeneric(long longSize, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode, @Cached CStructAccess.AllocateNode alloc) {
            int size = (int)longSize;
            if (longSize != (long)size) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.MemoryError);
            }
            Object mem = alloc.alloc((longSize + 1L) * 8L);
            NativeObjectSequenceStorage storage = NativeObjectSequenceStorage.create(mem, size, size, true);
            return factory.createTuple(storage);
        }
    }
}

