/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.graalvm.buildtools.maven.AbstractNativeImageMojo;
import org.graalvm.buildtools.maven.NativeExtension;
import org.graalvm.buildtools.utils.NativeImageConfigurationUtils;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST, requiresDependencyCollection=ResolutionScope.TEST)
public class NativeTestMojo
extends AbstractNativeImageMojo {
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="skipNativeTests", defaultValue="false")
    private boolean skipNativeTests;

    @Override
    protected void populateApplicationClasspath() throws MojoExecutionException {
        super.populateApplicationClasspath();
        this.imageClasspath.add(Paths.get(this.project.getBuild().getTestOutputDirectory(), new String[0]));
        this.project.getBuild().getTestResources().stream().map(FileSet::getDirectory).map(x$0 -> Paths.get(x$0, new String[0])).forEach(this.imageClasspath::add);
    }

    @Override
    protected List<String> getDependencyScopes() {
        return Arrays.asList("compile", "runtime", "test", "compile+runtime");
    }

    @Override
    protected void addDependenciesToClasspath() throws MojoExecutionException {
        super.addDependenciesToClasspath();
        HashSet<Module> modules = new HashSet<Module>();
        this.pluginArtifacts.stream().map(a -> {
            modules.add(new Module(a.getGroupId(), a.getArtifactId()));
            return a;
        }).filter(it -> it.getGroupId().startsWith("org.graalvm.buildtools") || it.getGroupId().startsWith("org.junit")).map(it -> it.getFile().toPath()).forEach(this.imageClasspath::add);
        List<Path> jars = this.findJunitPlatformNativeJars(modules);
        this.imageClasspath.addAll(jars);
    }

    public void execute() throws MojoExecutionException {
        if (this.skipTests || this.skipNativeTests) {
            this.logger.info("Skipping native-image tests (parameter 'skipTests' or 'skipNativeTests' is true).");
            return;
        }
        if (!this.hasTests()) {
            this.logger.info("Skipped native-image tests since there are no test classes.");
            return;
        }
        if (!this.hasTestIds()) {
            this.logger.error("Test configuration file wasn't found. Make sure that test execution wasn't skipped.");
            throw new IllegalStateException("Test configuration file wasn't found.");
        }
        this.logger.info("====================");
        this.logger.info("Initializing project: " + this.project.getName());
        this.logger.info("====================");
        this.configureEnvironment();
        this.buildArgs.add("--features=org.graalvm.junit.platform.JUnitPlatformFeature");
        if (this.systemProperties == null) {
            this.systemProperties = new HashMap();
        }
        this.systemProperties.put("junit.platform.listeners.uid.tracking.output.dir", NativeExtension.testIdsDirectory(this.outputDirectory.getAbsolutePath()));
        this.imageName = NativeImageConfigurationUtils.NATIVE_TESTS_EXE;
        this.mainClass = "org.graalvm.junit.platform.NativeImageJUnitLauncher";
        this.buildImage();
        this.runNativeTests(this.outputDirectory.toPath().resolve(NativeImageConfigurationUtils.NATIVE_TESTS_EXE));
    }

    private void configureEnvironment() {
        Object configuration;
        Plugin plugin = this.project.getPlugin("org.apache.maven.plugins:maven-surefire-plugin");
        if (plugin != null && (configuration = plugin.getConfiguration()) instanceof Xpp3Dom) {
            Xpp3Dom systemProps;
            Xpp3Dom dom = (Xpp3Dom)configuration;
            Xpp3Dom environmentVariables = dom.getChild("environmentVariables");
            if (environmentVariables != null) {
                Xpp3Dom[] children = environmentVariables.getChildren();
                if (this.environment == null) {
                    this.environment = new HashMap(children.length);
                }
                for (Xpp3Dom child : children) {
                    this.environment.put(child.getName(), child.getValue());
                }
            }
            if ((systemProps = dom.getChild("systemPropertyVariables")) != null) {
                Xpp3Dom[] children = systemProps.getChildren();
                if (this.systemProperties == null) {
                    this.systemProperties = new HashMap(children.length);
                }
                for (Xpp3Dom child : children) {
                    this.systemProperties.put(child.getName(), child.getValue());
                }
            }
        }
    }

    private boolean hasTests() {
        Path testOutputPath = Paths.get(this.project.getBuild().getTestOutputDirectory(), new String[0]);
        if (Files.exists(testOutputPath, new LinkOption[0]) && Files.isDirectory(testOutputPath, new LinkOption[0])) {
            boolean bl;
            block9: {
                Stream<Path> testClasses = Files.walk(testOutputPath, new FileVisitOption[0]);
                try {
                    bl = testClasses.anyMatch(p -> p.getFileName().toString().endsWith(".class"));
                    if (testClasses == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (testClasses != null) {
                            try {
                                testClasses.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
                testClasses.close();
            }
            return bl;
        }
        return false;
    }

    private void runNativeTests(Path executable) throws MojoExecutionException {
        Path xmlLocation = this.outputDirectory.toPath().resolve("native-test-reports");
        if (!xmlLocation.toFile().exists() && !xmlLocation.toFile().mkdirs()) {
            throw new MojoExecutionException("Failed creating xml output directory");
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(executable.toAbsolutePath().toString());
            processBuilder.inheritIO();
            processBuilder.directory(this.session.getCurrentProject().getBasedir());
            ArrayList<String> command = new ArrayList<String>();
            command.add("--xml-output-dir");
            command.add(xmlLocation.toString());
            this.systemProperties.forEach((key, value) -> command.add("-D" + key + "=" + value));
            processBuilder.command().addAll(command);
            processBuilder.environment().putAll(this.environment);
            String commandString = String.join((CharSequence)" ", processBuilder.command());
            this.getLog().info((CharSequence)("Executing: " + commandString));
            Process imageBuildProcess = processBuilder.start();
            if (imageBuildProcess.waitFor() != 0) {
                throw new MojoExecutionException("Execution of " + commandString + " returned non-zero result");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("native-image test run failed");
        }
    }

    private boolean hasTestIds() {
        try {
            Path buildDir = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
            return this.readAllFiles(buildDir, "junit-platform-unique-ids").anyMatch(contents -> !contents.isEmpty());
        }
        catch (Exception ex) {
            return false;
        }
    }

    private Stream<String> readAllFiles(Path dir, String prefix) throws IOException {
        return NativeTestMojo.findFiles(dir, prefix).map(outputFile -> {
            try {
                return Files.readAllLines(outputFile);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }).flatMap(Collection::stream);
    }

    private static Stream<Path> findFiles(Path dir, String prefix) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return Stream.empty();
        }
        return Files.find(dir, Integer.MAX_VALUE, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile() && path.getFileName().toString().startsWith(prefix), new FileVisitOption[0]);
    }

    private List<Path> findJunitPlatformNativeJars(Set<Module> modulesAlreadyOnClasspath) {
        DependencyResult dependencyResult;
        RepositorySystemSession repositorySession = this.mavenSession.getRepositorySession();
        DefaultRepositorySystemSession newSession = new DefaultRepositorySystemSession(repositorySession);
        CollectRequest collectRequest = new CollectRequest();
        List repositories = this.project.getRemoteProjectRepositories();
        collectRequest.setRepositories(repositories);
        DefaultArtifact artifact = new DefaultArtifact("org.graalvm.buildtools", "junit-platform-native", null, "jar", "0.10.6");
        Dependency dependency = new Dependency((Artifact)artifact, "runtime");
        collectRequest.addDependency(dependency);
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, null);
        try {
            dependencyResult = this.repositorySystem.resolveDependencies((RepositorySystemSession)newSession, dependencyRequest);
        }
        catch (DependencyResolutionException e) {
            return Collections.emptyList();
        }
        return dependencyResult.getArtifactResults().stream().map(ArtifactResult::getArtifact).filter(a -> !modulesAlreadyOnClasspath.contains(new Module(a.getGroupId(), a.getArtifactId()))).map(a -> a.getFile().toPath()).collect(Collectors.toList());
    }

    private static final class Module {
        private final String groupId;
        private final String artifactId;

        private Module(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Module module = (Module)o;
            if (!this.groupId.equals(module.groupId)) {
                return false;
            }
            return this.artifactId.equals(module.artifactId);
        }

        public int hashCode() {
            int result = this.groupId.hashCode();
            result = 31 * result + this.artifactId.hashCode();
            return result;
        }
    }
}

