/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.graalvm.buildtools.maven.AbstractNativeImageMojo;
import org.graalvm.buildtools.maven.sbom.SBOMGenerator;
import org.graalvm.buildtools.utils.NativeImageUtils;

@Mojo(name="compile-no-fork", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, requiresDependencyCollection=ResolutionScope.RUNTIME)
public class NativeCompileNoForkMojo
extends AbstractNativeImageMojo {
    @Parameter(property="skipNativeBuild", defaultValue="false")
    private boolean skip;
    @Parameter(property="skipNativeBuildForPom", defaultValue="false")
    private boolean skipNativeBuildForPom;
    @Parameter
    private Boolean augmentedSBOM;
    public static final String AUGMENTED_SBOM_PARAM_NAME = "augmentedSBOM";
    private PluginParameterExpressionEvaluator evaluator;

    @Override
    protected List<String> getDependencyScopes() {
        return Arrays.asList("compile", "runtime", "compile+runtime");
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.logger.info("Skipping native-image generation (parameter 'skipNativeBuild' is true).");
            return;
        }
        if (this.skipNativeBuildForPom && this.project.getPackaging().equals("pom")) {
            this.logger.info("Skipping native-image generation (parameter 'skipNativeBuildForPom' is true).");
            return;
        }
        this.evaluator = new PluginParameterExpressionEvaluator(this.session, this.mojoExecution);
        this.maybeSetMainClassFromPlugin(this::consumeExecutionsNodeValue, "org.apache.maven.plugins:maven-shade-plugin", "transformers", "transformer", "mainClass");
        this.maybeSetMainClassFromPlugin(this::consumeConfigurationNodeValue, "org.apache.maven.plugins:maven-assembly-plugin", "archive", "manifest", "mainClass");
        this.maybeSetMainClassFromPlugin(this::consumeConfigurationNodeValue, "org.apache.maven.plugins:maven-jar-plugin", "archive", "manifest", "mainClass");
        this.maybeAddGeneratedResourcesConfig(this.buildArgs);
        this.generateAugmentedSBOMIfNeeded();
        this.buildImage();
    }

    private void generateAugmentedSBOMIfNeeded() throws IllegalArgumentException, MojoExecutionException {
        boolean optionWasSet = this.augmentedSBOM != null;
        this.augmentedSBOM = optionWasSet ? this.augmentedSBOM : true;
        int detectedJDKVersion = NativeImageUtils.getMajorJDKVersion((String)NativeCompileNoForkMojo.getVersionInformation(this.logger));
        String sbomNativeImageFlag = "--enable-sbom";
        boolean sbomEnabledForNativeImage = this.getBuildArgs().stream().anyMatch(v -> v.contains(sbomNativeImageFlag));
        if (optionWasSet) {
            if (!this.augmentedSBOM.booleanValue()) {
                return;
            }
            if (!NativeCompileNoForkMojo.isOracleGraalVM(this.logger)) {
                throw new IllegalArgumentException(String.format("Configuration option %s is only supported in %s.", AUGMENTED_SBOM_PARAM_NAME, "Oracle GraalVM"));
            }
            SBOMGenerator.checkAugmentedSBOMSupportedByJDKVersion(detectedJDKVersion, true);
            if (!sbomEnabledForNativeImage) {
                this.buildArgs.add(sbomNativeImageFlag);
                this.logger.info(String.format("Automatically added build argument %s to Native Image because configuration option %s was set to true. An SBOM will be embedded in the image.", sbomNativeImageFlag, AUGMENTED_SBOM_PARAM_NAME));
            }
        } else {
            if (!NativeCompileNoForkMojo.isOracleGraalVM(this.logger) || !sbomEnabledForNativeImage) {
                return;
            }
            if (!SBOMGenerator.checkAugmentedSBOMSupportedByJDKVersion(detectedJDKVersion, false)) {
                return;
            }
        }
        SBOMGenerator sbomGenerator = new SBOMGenerator(this.mavenProject, this.mavenSession, this.pluginManager, this.repositorySystem, this.mainClass, this.logger);
        sbomGenerator.generate();
    }

    private String consumeConfigurationNodeValue(String pluginKey, String ... nodeNames) {
        Plugin selectedPlugin = this.project.getPlugin(pluginKey);
        if (selectedPlugin == null) {
            return null;
        }
        return this.getConfigurationNodeValue((ConfigurationContainer)selectedPlugin, nodeNames);
    }

    private String consumeExecutionsNodeValue(String pluginKey, String ... nodeNames) {
        Plugin selectedPlugin = this.project.getPlugin(pluginKey);
        if (selectedPlugin == null) {
            return null;
        }
        for (PluginExecution execution : selectedPlugin.getExecutions()) {
            String value = this.getConfigurationNodeValue((ConfigurationContainer)execution, nodeNames);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private String getConfigurationNodeValue(ConfigurationContainer container, String ... nodeNames) {
        if (container != null && container.getConfiguration() instanceof Xpp3Dom) {
            Xpp3Dom node = (Xpp3Dom)container.getConfiguration();
            for (String nodeName : nodeNames) {
                if ((node = node.getChild(nodeName)) != null) continue;
                return null;
            }
            String value = node.getValue();
            return this.evaluateValue(value);
        }
        return null;
    }

    private String evaluateValue(String value) {
        if (value != null) {
            try {
                Object evaluatedValue = this.evaluator.evaluate(value);
                if (evaluatedValue instanceof String) {
                    return (String)evaluatedValue;
                }
            }
            catch (ExpressionEvaluationException expressionEvaluationException) {
                // empty catch block
            }
        }
        return null;
    }

    private void maybeSetMainClassFromPlugin(BiFunction<String, String[], String> mainClassProvider, String pluginName, String ... nodeNames) {
        if (this.mainClass == null) {
            this.mainClass = mainClassProvider.apply(pluginName, nodeNames);
            if (this.mainClass != null) {
                this.logger.info("Obtained main class from plugin " + pluginName + " with the following path: " + String.join((CharSequence)" -> ", nodeNames));
            }
        }
    }
}

