/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.wsclients;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.wsclients.WSClientCheck;
import com.sun.enterprise.tools.verifier.tests.wsclients.WSClientTest;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class WSDLFileCheck
extends WSClientTest
implements WSClientCheck {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result check(ServiceReferenceDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        InputStream deploymentEntry = null;
        if (descriptor.hasWsdlFile()) {
            String wsdlUri = descriptor.getWsdlFileUri();
            URL url = null;
            try {
                url = new URL(wsdlUri);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (url != null && ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol()))) {
                return result;
            }
            try {
                String uri = this.getAbstractArchiveUri(descriptor);
                FileArchive arch = new FileArchive();
                arch.open(uri);
                deploymentEntry = arch.getEntry(wsdlUri);
                if (deploymentEntry == null) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "WSDL file does not exist in the archive at uri [{0}].", new Object[]{wsdlUri}));
                }
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "WSDL file exists in the archive at uri [{0}].", new Object[]{wsdlUri}));
            }
            catch (Exception e) {
                result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{e.getMessage()}));
            }
            finally {
                try {
                    if (deploymentEntry != null) {
                        deploymentEntry.close();
                    }
                }
                catch (IOException e) {}
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notapp", "Not applicable since Service Client does not have a WSDL file specified."));
        }
        return result;
    }
}

