/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.glassfish.bootstrap.ASMainFelix;
import com.sun.enterprise.module.bootstrap.ArgumentManager;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Properties;

public class VerifierOSGiMain {
    private static final String VERIFIER_MODULE = "org.glassfish.verifier";

    public static void main(String[] args) throws Exception {
        VerifierOSGiMain.setStartupContextProperties(args);
        ASMainFelix main = new ASMainFelix(){

            protected void setUpCache(File sourceDir, File cacheDir) throws IOException {
                if (System.getProperty("org.osgi.framework.storage") != null) {
                    System.out.println("Felix cache dir located at " + System.getProperty("org.osgi.framework.storage"));
                    return;
                }
                cacheDir = File.createTempFile("verifier-felix-cache", "tmp");
                if (!cacheDir.delete() || !cacheDir.mkdirs()) {
                    throw new IOException("Not able to create felix cache dir " + cacheDir.getAbsolutePath());
                }
                System.out.println("Felix cache dir created at " + cacheDir.getAbsolutePath());
                cacheDir.deleteOnExit();
                System.setProperty("org.osgi.framework.storage", cacheDir.getAbsolutePath());
            }
        };
        main.start(args);
    }

    private static void setStartupContextProperties(String ... args) throws IOException {
        Properties p = ArgumentManager.argsToMap((String[])args);
        p.put("__time_zero", new Long(System.currentTimeMillis()).toString());
        p.put("hk2.startup.context.mainModule", VERIFIER_MODULE);
        VerifierOSGiMain.addRawStartupInfo(args, p);
        StringWriter writer = new StringWriter();
        p.store(writer, null);
        System.setProperty("hk2.startup.context.args", ((Object)writer).toString());
    }

    private static void addRawStartupInfo(String[] args, Properties p) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(",,,");
            }
            sb.append(args[i]);
        }
        p.put("-startup-classpath", System.getProperty("java.class.path"));
        p.put("-startup-classname", VerifierOSGiMain.class.getName());
        p.put("-startup-args", sb.toString());
    }
}

