/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.common.util;

import com.sun.xml.registry.common.util.XMLUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;

public class MarshallerUtil {
    Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.registry.common");
    private static MarshallerUtil instance = null;
    private String jaxrHome = null;
    private JAXBContext jc = JAXBContext.newInstance((String)"com.sun.xml.registry.uddi.bindings_v2_2");

    protected MarshallerUtil() throws JAXBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MarshallerUtil getInstance() throws JAXBException {
        if (instance != null) return instance;
        Class<MarshallerUtil> clazz = MarshallerUtil.class;
        synchronized (MarshallerUtil.class) {
            if (instance != null) return instance;
            instance = new MarshallerUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public SOAPMessage jaxbMarshalObject(Object obj) throws JAXBException {
        SOAPMessage msg = null;
        Marshaller m = this.jc.createMarshaller();
        try {
            MessageFactory msgFactory = MessageFactory.newInstance();
            msg = msgFactory.createMessage();
            msg.setProperty("javax.xml.soap.write-xml-declaration", (Object)"true");
            m.marshal(obj, (Node)msg.getSOAPBody());
        }
        catch (SOAPException se) {
            throw new JAXBException((Throwable)se);
        }
        return msg;
    }

    public Object jaxbUnmarshalInputStream(InputStream result) throws JAXBException {
        Unmarshaller u = this.jc.createUnmarshaller();
        Object o = u.unmarshal(result);
        return o;
    }

    public OutputStream jaxbMarshalOutStream(Object result) throws JAXBException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Marshaller u = this.jc.createMarshaller();
        u.marshal(result, (OutputStream)outStream);
        return outStream;
    }

    public Object jaxbUnmarshalObject(Node result) throws JAXBException {
        Unmarshaller u = this.jc.createUnmarshaller();
        Object o = u.unmarshal(result);
        return o;
    }

    public static String generateUUID() {
        String uuid = null;
        try {
            uuid = InetAddress.getLocalHost() + new UID().toString();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return uuid;
    }

    public void log(SOAPMessage msg) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            msg.writeTo((OutputStream)outStream);
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.log(outStream);
    }

    private void log(ByteArrayOutputStream outStream) {
        String cmd = outStream.toString();
        if (this.logger.isLoggable(Level.FINEST)) {
            if (cmd.indexOf("get_authToken") != -1) {
                XMLUtil.getInstance();
                this.logger.finest(XMLUtil.authToken2XXX(cmd));
            } else if (cmd.indexOf("authInfo") != -1) {
                XMLUtil.getInstance();
                this.logger.finest(XMLUtil.authInfo2XXX(cmd));
            } else {
                this.logger.finest(cmd);
            }
        }
    }
}

