/*
 * Copyright (c) 1997, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.xml.rpc.wsdl.document;

import com.sun.xml.rpc.wsdl.framework.ExtensionVisitor;

/**
 * A visitor for WSDL documents.
 *
 * @author JAX-RPC Development Team
 */
public interface WSDLDocumentVisitor extends ExtensionVisitor {

    public void preVisit(Definitions definitions) throws Exception;
    public void postVisit(Definitions definitions) throws Exception;
    public void visit(Import i) throws Exception;
    public void preVisit(Types types) throws Exception;
    public void postVisit(Types types) throws Exception;
    public void preVisit(Message message) throws Exception;
    public void postVisit(Message message) throws Exception;
    public void visit(MessagePart part) throws Exception;
    public void preVisit(PortType portType) throws Exception;
    public void postVisit(PortType portType) throws Exception;
    public void preVisit(Operation operation) throws Exception;
    public void postVisit(Operation operation) throws Exception;
    public void preVisit(Input input) throws Exception;
    public void postVisit(Input input) throws Exception;
    public void preVisit(Output output) throws Exception;
    public void postVisit(Output output) throws Exception;
    public void preVisit(Fault fault) throws Exception;
    public void postVisit(Fault fault) throws Exception;
    public void preVisit(Binding binding) throws Exception;
    public void postVisit(Binding binding) throws Exception;
    public void preVisit(BindingOperation operation) throws Exception;
    public void postVisit(BindingOperation operation) throws Exception;
    public void preVisit(BindingInput input) throws Exception;
    public void postVisit(BindingInput input) throws Exception;
    public void preVisit(BindingOutput output) throws Exception;
    public void postVisit(BindingOutput output) throws Exception;
    public void preVisit(BindingFault fault) throws Exception;
    public void postVisit(BindingFault fault) throws Exception;
    public void preVisit(Service service) throws Exception;
    public void postVisit(Service service) throws Exception;
    public void preVisit(Port port) throws Exception;
    public void postVisit(Port port) throws Exception;
    public void visit(Documentation documentation) throws Exception;
}
