/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.kerb;

import com.sun.xml.ws.security.kerb.Krb5Token;
import com.sun.xml.ws.security.kerb.Krb5Util;
import com.sun.xml.ws.security.kerb.WrapToken;
import com.sun.xml.ws.security.kerb.WrapToken_v2;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.ietf.jgss.GSSException;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.internal.crypto.Aes128;
import sun.security.krb5.internal.crypto.Aes256;
import sun.security.krb5.internal.crypto.ArcFourHmac;
import sun.security.krb5.internal.crypto.Des3;

class CipherHelper {
    private static final int KG_USAGE_SEAL = 22;
    private static final int KG_USAGE_SIGN = 23;
    private static final int KG_USAGE_SEQ = 24;
    private static final int DES_CHECKSUM_SIZE = 8;
    private static final int DES_IV_SIZE = 8;
    private static final int AES_IV_SIZE = 16;
    private static final int HMAC_CHECKSUM_SIZE = 8;
    private static final int KG_USAGE_SIGN_MS = 15;
    private static final boolean DEBUG = Krb5Util.DEBUG;
    private static final byte[] ZERO_IV = new byte[8];
    private static final byte[] ZERO_IV_AES = new byte[16];
    private int etype;
    private int sgnAlg;
    private int sealAlg;
    private byte[] keybytes;
    private int proto = 0;

    CipherHelper(EncryptionKey key) throws GSSException {
        this.etype = key.getEType();
        this.keybytes = key.getBytes();
        switch (this.etype) {
            case 1: 
            case 3: {
                this.sgnAlg = 0;
                this.sealAlg = 0;
                break;
            }
            case 16: {
                this.sgnAlg = 1024;
                this.sealAlg = 512;
                break;
            }
            case 23: {
                this.sgnAlg = 4352;
                this.sealAlg = 4096;
                break;
            }
            case 17: 
            case 18: {
                this.sgnAlg = -1;
                this.sealAlg = -1;
                this.proto = 1;
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported encryption type: " + this.etype);
            }
        }
    }

    int getSgnAlg() {
        return this.sgnAlg;
    }

    int getSealAlg() {
        return this.sealAlg;
    }

    int getProto() {
        return this.proto;
    }

    int getEType() {
        return this.etype;
    }

    boolean isArcFour() {
        boolean flag = false;
        if (this.etype == 23) {
            flag = true;
        }
        return flag;
    }

    byte[] calculateChecksum(int alg, byte[] header, byte[] trailer, byte[] data, int start, int len, int tokenId) throws GSSException {
        switch (alg) {
            case 0: {
                try {
                    MessageDigest md5 = MessageDigest.getInstance("MD5");
                    md5.update(header);
                    md5.update(data, start, len);
                    if (trailer != null) {
                        md5.update(trailer);
                    }
                    data = md5.digest();
                    start = 0;
                    len = data.length;
                    header = null;
                    trailer = null;
                }
                catch (NoSuchAlgorithmException e) {
                    GSSException ge = new GSSException(11, -1, "Could not get MD5 Message Digest - " + e.getMessage());
                    ge.initCause(e);
                    throw ge;
                }
            }
            case 512: {
                return this.getDesCbcChecksum(this.keybytes, header, data, start, len);
            }
            case 1024: {
                int offset;
                int total;
                byte[] buf;
                if (header == null && trailer == null) {
                    buf = data;
                    total = len;
                    offset = start;
                } else {
                    total = (header != null ? header.length : 0) + len + (trailer != null ? trailer.length : 0);
                    buf = new byte[total];
                    int pos = 0;
                    if (header != null) {
                        System.arraycopy(header, 0, buf, 0, header.length);
                        pos = header.length;
                    }
                    System.arraycopy(data, start, buf, pos, len);
                    pos += len;
                    if (trailer != null) {
                        System.arraycopy(trailer, 0, buf, pos, trailer.length);
                    }
                    offset = 0;
                }
                try {
                    byte[] answer = Des3.calculateChecksum(this.keybytes, 23, buf, offset, total);
                    return answer;
                }
                catch (GeneralSecurityException e) {
                    GSSException ge = new GSSException(11, -1, "Could not use HMAC-SHA1-DES3-KD signing algorithm - " + e.getMessage());
                    ge.initCause(e);
                    throw ge;
                }
            }
            case 4352: {
                int off;
                int tot;
                byte[] buffer;
                if (header == null && trailer == null) {
                    buffer = data;
                    tot = len;
                    off = start;
                } else {
                    tot = (header != null ? header.length : 0) + len + (trailer != null ? trailer.length : 0);
                    buffer = new byte[tot];
                    int pos = 0;
                    if (header != null) {
                        System.arraycopy(header, 0, buffer, 0, header.length);
                        pos = header.length;
                    }
                    System.arraycopy(data, start, buffer, pos, len);
                    pos += len;
                    if (trailer != null) {
                        System.arraycopy(trailer, 0, buffer, pos, trailer.length);
                    }
                    off = 0;
                }
                try {
                    int key_usage = 23;
                    if (tokenId == 257) {
                        key_usage = 15;
                    }
                    byte[] answer = ArcFourHmac.calculateChecksum(this.keybytes, key_usage, buffer, off, tot);
                    byte[] output = new byte[this.getChecksumLength()];
                    System.arraycopy(answer, 0, output, 0, output.length);
                    return output;
                }
                catch (GeneralSecurityException e) {
                    GSSException ge = new GSSException(11, -1, "Could not use HMAC_MD5_ARCFOUR signing algorithm - " + e.getMessage());
                    ge.initCause(e);
                    throw ge;
                }
            }
        }
        throw new GSSException(11, -1, "Unsupported signing algorithm: " + this.sgnAlg);
    }

    byte[] calculateChecksum(byte[] header, byte[] data, int start, int len, int key_usage) throws GSSException {
        int total = (header != null ? header.length : 0) + len;
        byte[] buf = new byte[total];
        System.arraycopy(data, start, buf, 0, len);
        if (header != null) {
            System.arraycopy(header, 0, buf, len, header.length);
        }
        switch (this.etype) {
            case 17: {
                try {
                    byte[] answer = Aes128.calculateChecksum(this.keybytes, key_usage, buf, 0, total);
                    return answer;
                }
                catch (GeneralSecurityException e) {
                    GSSException ge = new GSSException(11, -1, "Could not use AES128 signing algorithm - " + e.getMessage());
                    ge.initCause(e);
                    throw ge;
                }
            }
            case 18: {
                try {
                    byte[] answer = Aes256.calculateChecksum(this.keybytes, key_usage, buf, 0, total);
                    return answer;
                }
                catch (GeneralSecurityException e) {
                    GSSException ge = new GSSException(11, -1, "Could not use AES256 signing algorithm - " + e.getMessage());
                    ge.initCause(e);
                    throw ge;
                }
            }
        }
        throw new GSSException(11, -1, "Unsupported encryption type: " + this.etype);
    }

    byte[] encryptSeq(byte[] ivec, byte[] plaintext, int start, int len) throws GSSException {
        switch (this.sgnAlg) {
            case 0: 
            case 512: {
                try {
                    Cipher des = this.getInitializedDes(true, this.keybytes, ivec);
                    return des.doFinal(plaintext, start, len);
                }
                catch (GeneralSecurityException e) {
                    GSSException ge = new GSSException(11, -1, "Could not encrypt sequence number using DES - " + e.getMessage());
                    ge.initCause(e);
                    throw ge;
                }
            }
            case 1024: {
                byte[] iv;
                if (ivec.length == 8) {
                    iv = ivec;
                } else {
                    iv = new byte[8];
                    System.arraycopy(ivec, 0, iv, 0, 8);
                }
                try {
                    return Des3.encryptRaw(this.keybytes, 24, iv, plaintext, start, len);
                }
                catch (Exception e) {
                    GSSException ge = new GSSException(11, -1, "Could not encrypt sequence number using DES3-KD - " + e.getMessage());
                    ge.initCause(e);
                    throw ge;
                }
            }
            case 4352: {
                byte[] checksum;
                if (ivec.length == 8) {
                    checksum = ivec;
                } else {
                    checksum = new byte[8];
                    System.arraycopy(ivec, 0, checksum, 0, 8);
                }
                try {
                    return ArcFourHmac.encryptSeq(this.keybytes, 24, checksum, plaintext, start, len);
                }
                catch (Exception e) {
                    GSSException ge = new GSSException(11, -1, "Could not encrypt sequence number using RC4-HMAC - " + e.getMessage());
                    ge.initCause(e);
                    throw ge;
                }
            }
        }
        throw new GSSException(11, -1, "Unsupported signing algorithm: " + this.sgnAlg);
    }

    byte[] decryptSeq(byte[] ivec, byte[] ciphertext, int start, int len) throws GSSException {
        switch (this.sgnAlg) {
            case 0: 
            case 512: {
                try {
                    Cipher des = this.getInitializedDes(false, this.keybytes, ivec);
                    return des.doFinal(ciphertext, start, len);
                }
                catch (GeneralSecurityException e) {
                    GSSException ge = new GSSException(11, -1, "Could not decrypt sequence number using DES - " + e.getMessage());
                    ge.initCause(e);
                    throw ge;
                }
            }
            case 1024: {
                byte[] iv;
                if (ivec.length == 8) {
                    iv = ivec;
                } else {
                    iv = new byte[8];
                    System.arraycopy(ivec, 0, iv, 0, 8);
                }
                try {
                    return Des3.decryptRaw(this.keybytes, 24, iv, ciphertext, start, len);
                }
                catch (Exception e) {
                    GSSException ge = new GSSException(11, -1, "Could not decrypt sequence number using DES3-KD - " + e.getMessage());
                    ge.initCause(e);
                    throw ge;
                }
            }
            case 4352: {
                byte[] checksum;
                if (ivec.length == 8) {
                    checksum = ivec;
                } else {
                    checksum = new byte[8];
                    System.arraycopy(ivec, 0, checksum, 0, 8);
                }
                try {
                    return ArcFourHmac.decryptSeq(this.keybytes, 24, checksum, ciphertext, start, len);
                }
                catch (Exception e) {
                    GSSException ge = new GSSException(11, -1, "Could not decrypt sequence number using RC4-HMAC - " + e.getMessage());
                    ge.initCause(e);
                    throw ge;
                }
            }
        }
        throw new GSSException(11, -1, "Unsupported signing algorithm: " + this.sgnAlg);
    }

    int getChecksumLength() throws GSSException {
        switch (this.etype) {
            case 1: 
            case 3: {
                return 8;
            }
            case 16: {
                return Des3.getChecksumLength();
            }
            case 17: {
                return Aes128.getChecksumLength();
            }
            case 18: {
                return Aes256.getChecksumLength();
            }
            case 23: {
                return 8;
            }
        }
        throw new GSSException(11, -1, "Unsupported encryption type: " + this.etype);
    }

    void decryptData(WrapToken token, byte[] ciphertext, int cStart, int cLen, byte[] plaintext, int pStart) throws GSSException {
        switch (this.sealAlg) {
            case 0: {
                this.desCbcDecrypt(token, CipherHelper.getDesEncryptionKey(this.keybytes), ciphertext, cStart, cLen, plaintext, pStart);
                break;
            }
            case 512: {
                this.des3KdDecrypt(token, ciphertext, cStart, cLen, plaintext, pStart);
                break;
            }
            case 4096: {
                this.arcFourDecrypt(token, ciphertext, cStart, cLen, plaintext, pStart);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported seal algorithm: " + this.sealAlg);
            }
        }
    }

    void decryptData(WrapToken_v2 token, byte[] ciphertext, int cStart, int cLen, byte[] plaintext, int pStart, int key_usage) throws GSSException {
        switch (this.etype) {
            case 17: {
                this.aes128Decrypt(token, ciphertext, cStart, cLen, plaintext, pStart, key_usage);
                break;
            }
            case 18: {
                this.aes256Decrypt(token, ciphertext, cStart, cLen, plaintext, pStart, key_usage);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported etype: " + this.etype);
            }
        }
    }

    void decryptData(WrapToken token, InputStream cipherStream, int cLen, byte[] plaintext, int pStart) throws GSSException, IOException {
        switch (this.sealAlg) {
            case 0: {
                this.desCbcDecrypt(token, CipherHelper.getDesEncryptionKey(this.keybytes), cipherStream, cLen, plaintext, pStart);
                break;
            }
            case 512: {
                byte[] ciphertext = new byte[cLen];
                try {
                    Krb5Token.readFully(cipherStream, ciphertext, 0, cLen);
                }
                catch (IOException e) {
                    GSSException ge = new GSSException(10, -1, "Cannot read complete token");
                    ge.initCause(e);
                    throw ge;
                }
                this.des3KdDecrypt(token, ciphertext, 0, cLen, plaintext, pStart);
                break;
            }
            case 4096: {
                byte[] ctext = new byte[cLen];
                try {
                    Krb5Token.readFully(cipherStream, ctext, 0, cLen);
                }
                catch (IOException e) {
                    GSSException ge = new GSSException(10, -1, "Cannot read complete token");
                    ge.initCause(e);
                    throw ge;
                }
                this.arcFourDecrypt(token, ctext, 0, cLen, plaintext, pStart);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported seal algorithm: " + this.sealAlg);
            }
        }
    }

    void decryptData(WrapToken_v2 token, InputStream cipherStream, int cLen, byte[] plaintext, int pStart, int key_usage) throws GSSException, IOException {
        byte[] ciphertext = new byte[cLen];
        try {
            Krb5Token.readFully(cipherStream, ciphertext, 0, cLen);
        }
        catch (IOException e) {
            GSSException ge = new GSSException(10, -1, "Cannot read complete token");
            ge.initCause(e);
            throw ge;
        }
        switch (this.etype) {
            case 17: {
                this.aes128Decrypt(token, ciphertext, 0, cLen, plaintext, pStart, key_usage);
                break;
            }
            case 18: {
                this.aes256Decrypt(token, ciphertext, 0, cLen, plaintext, pStart, key_usage);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported etype: " + this.etype);
            }
        }
    }

    void encryptData(WrapToken token, byte[] confounder, byte[] plaintext, int start, int len, byte[] padding, OutputStream os) throws GSSException, IOException {
        switch (this.sealAlg) {
            case 0: {
                Cipher des = this.getInitializedDes(true, CipherHelper.getDesEncryptionKey(this.keybytes), ZERO_IV);
                CipherOutputStream cos = new CipherOutputStream(os, des);
                cos.write(confounder);
                cos.write(plaintext, start, len);
                cos.write(padding);
                break;
            }
            case 512: {
                byte[] ctext = this.des3KdEncrypt(confounder, plaintext, start, len, padding);
                os.write(ctext);
                break;
            }
            case 4096: {
                byte[] ciphertext = this.arcFourEncrypt(token, confounder, plaintext, start, len, padding);
                os.write(ciphertext);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported seal algorithm: " + this.sealAlg);
            }
        }
    }

    void encryptData(WrapToken_v2 token, byte[] confounder, byte[] tokenHeader, byte[] plaintext, int start, int len, int key_usage, OutputStream os) throws GSSException, IOException {
        byte[] ctext = null;
        switch (this.etype) {
            case 17: {
                ctext = this.aes128Encrypt(confounder, tokenHeader, plaintext, start, len, key_usage);
                break;
            }
            case 18: {
                ctext = this.aes256Encrypt(confounder, tokenHeader, plaintext, start, len, key_usage);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported etype: " + this.etype);
            }
        }
        os.write(ctext);
    }

    void encryptData(WrapToken token, byte[] confounder, byte[] plaintext, int pStart, int pLen, byte[] padding, byte[] ciphertext, int cStart) throws GSSException {
        switch (this.sealAlg) {
            case 0: {
                int pos = cStart;
                Cipher des = this.getInitializedDes(true, CipherHelper.getDesEncryptionKey(this.keybytes), ZERO_IV);
                try {
                    pos += des.update(confounder, 0, confounder.length, ciphertext, pos);
                    pos += des.update(plaintext, pStart, pLen, ciphertext, pos);
                    des.update(padding, 0, padding.length, ciphertext, pos);
                    des.doFinal();
                    break;
                }
                catch (GeneralSecurityException e) {
                    GSSException ge = new GSSException(11, -1, "Could not use DES Cipher - " + e.getMessage());
                    ge.initCause(e);
                    throw ge;
                }
            }
            case 512: {
                byte[] ctext = this.des3KdEncrypt(confounder, plaintext, pStart, pLen, padding);
                System.arraycopy(ctext, 0, ciphertext, cStart, ctext.length);
                break;
            }
            case 4096: {
                byte[] ctext2 = this.arcFourEncrypt(token, confounder, plaintext, pStart, pLen, padding);
                System.arraycopy(ctext2, 0, ciphertext, cStart, ctext2.length);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported seal algorithm: " + this.sealAlg);
            }
        }
    }

    int encryptData(WrapToken_v2 token, byte[] confounder, byte[] tokenHeader, byte[] plaintext, int pStart, int pLen, byte[] ciphertext, int cStart, int key_usage) throws GSSException {
        byte[] ctext = null;
        switch (this.etype) {
            case 17: {
                ctext = this.aes128Encrypt(confounder, tokenHeader, plaintext, pStart, pLen, key_usage);
                break;
            }
            case 18: {
                ctext = this.aes256Encrypt(confounder, tokenHeader, plaintext, pStart, pLen, key_usage);
                break;
            }
            default: {
                throw new GSSException(11, -1, "Unsupported etype: " + this.etype);
            }
        }
        System.arraycopy(ctext, 0, ciphertext, cStart, ctext.length);
        return ctext.length;
    }

    private byte[] getDesCbcChecksum(byte[] key, byte[] header, byte[] data, int offset, int len) throws GSSException {
        Cipher des = this.getInitializedDes(true, key, ZERO_IV);
        int blockSize = des.getBlockSize();
        byte[] finalBlock = new byte[blockSize];
        int numBlocks = len / blockSize;
        int lastBytes = len % blockSize;
        if (lastBytes == 0) {
            System.arraycopy(data, offset + --numBlocks * blockSize, finalBlock, 0, blockSize);
        } else {
            System.arraycopy(data, offset + numBlocks * blockSize, finalBlock, 0, lastBytes);
        }
        try {
            byte[] temp = new byte[Math.max(blockSize, header == null ? blockSize : header.length)];
            if (header != null) {
                des.update(header, 0, header.length, temp, 0);
            }
            for (int i = 0; i < numBlocks; ++i) {
                des.update(data, offset, blockSize, temp, 0);
                offset += blockSize;
            }
            byte[] retVal = new byte[blockSize];
            des.update(finalBlock, 0, blockSize, retVal, 0);
            des.doFinal();
            return retVal;
        }
        catch (GeneralSecurityException e) {
            GSSException ge = new GSSException(11, -1, "Could not use DES Cipher - " + e.getMessage());
            ge.initCause(e);
            throw ge;
        }
    }

    private final Cipher getInitializedDes(boolean encryptMode, byte[] key, byte[] ivBytes) throws GSSException {
        try {
            IvParameterSpec iv = new IvParameterSpec(ivBytes);
            SecretKeySpec jceKey = new SecretKeySpec(key, "DES");
            Cipher desCipher = Cipher.getInstance("DES/CBC/NoPadding");
            desCipher.init(encryptMode ? 1 : 2, (Key)jceKey, iv);
            return desCipher;
        }
        catch (GeneralSecurityException e) {
            GSSException ge = new GSSException(11, -1, e.getMessage());
            ge.initCause(e);
            throw ge;
        }
    }

    private void desCbcDecrypt(WrapToken token, byte[] key, byte[] cipherText, int offset, int len, byte[] dataOutBuf, int dataOffset) throws GSSException {
        try {
            int temp = 0;
            Cipher des = this.getInitializedDes(false, key, ZERO_IV);
            temp = des.update(cipherText, offset, 8, token.confounder);
            offset += 8;
            int blockSize = des.getBlockSize();
            int numBlocks = (len -= 8) / blockSize - 1;
            for (int i = 0; i < numBlocks; ++i) {
                temp = des.update(cipherText, offset, blockSize, dataOutBuf, dataOffset);
                offset += blockSize;
                dataOffset += blockSize;
            }
            byte[] finalBlock = new byte[blockSize];
            des.update(cipherText, offset, blockSize, finalBlock);
            des.doFinal();
            byte padSize = finalBlock[blockSize - 1];
            if (padSize < 1 || padSize > 8) {
                throw new GSSException(10, -1, "Invalid padding on Wrap Token");
            }
            token.padding = WrapToken.pads[padSize];
            System.arraycopy(finalBlock, 0, dataOutBuf, dataOffset, blockSize -= padSize);
        }
        catch (GeneralSecurityException e) {
            GSSException ge = new GSSException(11, -1, "Could not use DES cipher - " + e.getMessage());
            ge.initCause(e);
            throw ge;
        }
    }

    private void desCbcDecrypt(WrapToken token, byte[] key, InputStream is, int len, byte[] dataOutBuf, int dataOffset) throws GSSException, IOException {
        int temp = 0;
        Cipher des = this.getInitializedDes(false, key, ZERO_IV);
        WrapTokenInputStream truncatedInputStream = new WrapTokenInputStream(is, len);
        CipherInputStream cis = new CipherInputStream(truncatedInputStream, des);
        temp = cis.read(token.confounder);
        int blockSize = des.getBlockSize();
        int numBlocks = (len -= temp) / blockSize - 1;
        for (int i = 0; i < numBlocks; ++i) {
            temp = cis.read(dataOutBuf, dataOffset, blockSize);
            dataOffset += blockSize;
        }
        byte[] finalBlock = new byte[blockSize];
        temp = cis.read(finalBlock);
        try {
            des.doFinal();
        }
        catch (GeneralSecurityException e) {
            GSSException ge = new GSSException(11, -1, "Could not use DES cipher - " + e.getMessage());
            ge.initCause(e);
            throw ge;
        }
        byte padSize = finalBlock[blockSize - 1];
        if (padSize < 1 || padSize > 8) {
            throw new GSSException(10, -1, "Invalid padding on Wrap Token");
        }
        token.padding = WrapToken.pads[padSize];
        System.arraycopy(finalBlock, 0, dataOutBuf, dataOffset, blockSize -= padSize);
    }

    private static byte[] getDesEncryptionKey(byte[] key) throws GSSException {
        if (key.length > 8) {
            throw new GSSException(11, -100, "Invalid DES Key!");
        }
        byte[] retVal = new byte[key.length];
        for (int i = 0; i < key.length; ++i) {
            retVal[i] = (byte)(key[i] ^ 0xF0);
        }
        return retVal;
    }

    private void des3KdDecrypt(WrapToken token, byte[] ciphertext, int cStart, int cLen, byte[] plaintext, int pStart) throws GSSException {
        byte[] ptext;
        try {
            ptext = Des3.decryptRaw(this.keybytes, 22, ZERO_IV, ciphertext, cStart, cLen);
        }
        catch (GeneralSecurityException e) {
            GSSException ge = new GSSException(11, -1, "Could not use DES3-KD Cipher - " + e.getMessage());
            ge.initCause(e);
            throw ge;
        }
        byte padSize = ptext[ptext.length - 1];
        if (padSize < 1 || padSize > 8) {
            throw new GSSException(10, -1, "Invalid padding on Wrap Token");
        }
        token.padding = WrapToken.pads[padSize];
        int len = ptext.length - 8 - padSize;
        System.arraycopy(ptext, 8, plaintext, pStart, len);
        System.arraycopy(ptext, 0, token.confounder, 0, 8);
    }

    private byte[] des3KdEncrypt(byte[] confounder, byte[] plaintext, int start, int len, byte[] padding) throws GSSException {
        byte[] all = new byte[confounder.length + len + padding.length];
        System.arraycopy(confounder, 0, all, 0, confounder.length);
        System.arraycopy(plaintext, start, all, confounder.length, len);
        System.arraycopy(padding, 0, all, confounder.length + len, padding.length);
        try {
            byte[] answer = Des3.encryptRaw(this.keybytes, 22, ZERO_IV, all, 0, all.length);
            return answer;
        }
        catch (Exception e) {
            GSSException ge = new GSSException(11, -1, "Could not use DES3-KD Cipher - " + e.getMessage());
            ge.initCause(e);
            throw ge;
        }
    }

    private void arcFourDecrypt(WrapToken token, byte[] ciphertext, int cStart, int cLen, byte[] plaintext, int pStart) throws GSSException {
        byte[] ptext;
        byte[] seqNum = this.decryptSeq(token.getChecksum(), token.getEncSeqNumber(), 0, 8);
        try {
            ptext = ArcFourHmac.decryptRaw(this.keybytes, 22, ZERO_IV, ciphertext, cStart, cLen, seqNum);
        }
        catch (GeneralSecurityException e) {
            GSSException ge = new GSSException(11, -1, "Could not use ArcFour Cipher - " + e.getMessage());
            ge.initCause(e);
            throw ge;
        }
        byte padSize = ptext[ptext.length - 1];
        if (padSize < 1) {
            throw new GSSException(10, -1, "Invalid padding on Wrap Token");
        }
        token.padding = WrapToken.pads[padSize];
        int len = ptext.length - 8 - padSize;
        System.arraycopy(ptext, 8, plaintext, pStart, len);
        System.arraycopy(ptext, 0, token.confounder, 0, 8);
    }

    private byte[] arcFourEncrypt(WrapToken token, byte[] confounder, byte[] plaintext, int start, int len, byte[] padding) throws GSSException {
        byte[] all = new byte[confounder.length + len + padding.length];
        System.arraycopy(confounder, 0, all, 0, confounder.length);
        System.arraycopy(plaintext, start, all, confounder.length, len);
        System.arraycopy(padding, 0, all, confounder.length + len, padding.length);
        byte[] seqNum = new byte[4];
        WrapToken.writeBigEndian(token.getSequenceNumber(), seqNum);
        try {
            byte[] answer = ArcFourHmac.encryptRaw(this.keybytes, 22, seqNum, all, 0, all.length);
            return answer;
        }
        catch (Exception e) {
            GSSException ge = new GSSException(11, -1, "Could not use ArcFour Cipher - " + e.getMessage());
            ge.initCause(e);
            throw ge;
        }
    }

    private byte[] aes128Encrypt(byte[] confounder, byte[] tokenHeader, byte[] plaintext, int start, int len, int key_usage) throws GSSException {
        byte[] all = new byte[confounder.length + len + tokenHeader.length];
        System.arraycopy(confounder, 0, all, 0, confounder.length);
        System.arraycopy(plaintext, start, all, confounder.length, len);
        System.arraycopy(tokenHeader, 0, all, confounder.length + len, tokenHeader.length);
        try {
            byte[] answer = Aes128.encryptRaw(this.keybytes, key_usage, ZERO_IV_AES, all, 0, all.length);
            return answer;
        }
        catch (Exception e) {
            GSSException ge = new GSSException(11, -1, "Could not use AES128 Cipher - " + e.getMessage());
            ge.initCause(e);
            throw ge;
        }
    }

    private void aes128Decrypt(WrapToken_v2 token, byte[] ciphertext, int cStart, int cLen, byte[] plaintext, int pStart, int key_usage) throws GSSException {
        byte[] ptext = null;
        try {
            ptext = Aes128.decryptRaw(this.keybytes, key_usage, ZERO_IV_AES, ciphertext, cStart, cLen);
        }
        catch (GeneralSecurityException e) {
            GSSException ge = new GSSException(11, -1, "Could not use AES128 Cipher - " + e.getMessage());
            ge.initCause(e);
            throw ge;
        }
        int len = ptext.length - 16 - 16;
        System.arraycopy(ptext, 16, plaintext, pStart, len);
    }

    private byte[] aes256Encrypt(byte[] confounder, byte[] tokenHeader, byte[] plaintext, int start, int len, int key_usage) throws GSSException {
        byte[] all = new byte[confounder.length + len + tokenHeader.length];
        System.arraycopy(confounder, 0, all, 0, confounder.length);
        System.arraycopy(plaintext, start, all, confounder.length, len);
        System.arraycopy(tokenHeader, 0, all, confounder.length + len, tokenHeader.length);
        try {
            byte[] answer = Aes256.encryptRaw(this.keybytes, key_usage, ZERO_IV_AES, all, 0, all.length);
            return answer;
        }
        catch (Exception e) {
            GSSException ge = new GSSException(11, -1, "Could not use AES256 Cipher - " + e.getMessage());
            ge.initCause(e);
            throw ge;
        }
    }

    private void aes256Decrypt(WrapToken_v2 token, byte[] ciphertext, int cStart, int cLen, byte[] plaintext, int pStart, int key_usage) throws GSSException {
        byte[] ptext;
        try {
            ptext = Aes256.decryptRaw(this.keybytes, key_usage, ZERO_IV_AES, ciphertext, cStart, cLen);
        }
        catch (GeneralSecurityException e) {
            GSSException ge = new GSSException(11, -1, "Could not use AES128 Cipher - " + e.getMessage());
            ge.initCause(e);
            throw ge;
        }
        int len = ptext.length - 16 - 16;
        System.arraycopy(ptext, 16, plaintext, pStart, len);
    }

    class WrapTokenInputStream
    extends InputStream {
        private InputStream is;
        private int length;
        private int remaining;
        private int temp;

        public WrapTokenInputStream(InputStream is, int length) {
            this.is = is;
            this.length = length;
            this.remaining = length;
        }

        public final int read() throws IOException {
            if (this.remaining == 0) {
                return -1;
            }
            this.temp = this.is.read();
            if (this.temp != -1) {
                this.remaining -= this.temp;
            }
            return this.temp;
        }

        public final int read(byte[] b) throws IOException {
            if (this.remaining == 0) {
                return -1;
            }
            this.temp = Math.min(this.remaining, b.length);
            this.temp = this.is.read(b, 0, this.temp);
            if (this.temp != -1) {
                this.remaining -= this.temp;
            }
            return this.temp;
        }

        public final int read(byte[] b, int off, int len) throws IOException {
            if (this.remaining == 0) {
                return -1;
            }
            this.temp = Math.min(this.remaining, len);
            this.temp = this.is.read(b, off, this.temp);
            if (this.temp != -1) {
                this.remaining -= this.temp;
            }
            return this.temp;
        }

        public final long skip(long n) throws IOException {
            if (this.remaining == 0) {
                return 0L;
            }
            this.temp = (int)Math.min((long)this.remaining, n);
            this.temp = (int)this.is.skip(this.temp);
            this.remaining -= this.temp;
            return this.temp;
        }

        public final int available() throws IOException {
            return Math.min(this.remaining, this.is.available());
        }

        public final void close() throws IOException {
            this.remaining = 0;
        }
    }
}

