
package org.glassfish.jersey.jsonb;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private static final String BUNDLE_NAME = "org.glassfish.jersey.jsonb.localization";
    private static final LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private static final Localizer LOCALIZER = new Localizer();

    private LocalizationMessages() {
    }

    public static Localizable localizableERROR_JSONB_SERIALIZATION() {
        return MESSAGE_FACTORY.getMessage("error.jsonb.serialization");
    }

    /**
     * Error writing JSON-B serialized object.
     * 
     */
    public static String ERROR_JSONB_SERIALIZATION() {
        return LOCALIZER.localize(localizableERROR_JSONB_SERIALIZATION());
    }

    public static Localizable localizableERROR_JSONB_DETECTING_APPLICATION(Object arg0) {
        return MESSAGE_FACTORY.getMessage("error.jsonb.detecting.application", arg0);
    }

    /**
     * JSON-B could not detect the application name: {0}.
     * 
     */
    public static String ERROR_JSONB_DETECTING_APPLICATION(Object arg0) {
        return LOCALIZER.localize(localizableERROR_JSONB_DETECTING_APPLICATION(arg0));
    }

    public static Localizable localizableERROR_JSONB_EMPTYSTREAM() {
        return MESSAGE_FACTORY.getMessage("error.jsonb.emptystream");
    }

    /**
     * JSON-B cannot parse empty input stream.
     * 
     */
    public static String ERROR_JSONB_EMPTYSTREAM() {
        return LOCALIZER.localize(localizableERROR_JSONB_EMPTYSTREAM());
    }

    public static Localizable localizableERROR_JSONB_DESERIALIZATION() {
        return MESSAGE_FACTORY.getMessage("error.jsonb.deserialization");
    }

    /**
     * Error deserializing object from entity stream.
     * 
     */
    public static String ERROR_JSONB_DESERIALIZATION() {
        return LOCALIZER.localize(localizableERROR_JSONB_DESERIALIZATION());
    }

    public static Localizable localizableERROR_JSONB_APPLICATION_NOT_FOUND() {
        return MESSAGE_FACTORY.getMessage("error.jsonb.application.not.found");
    }

    /**
     * Application not found.
     * 
     */
    public static String ERROR_JSONB_APPLICATION_NOT_FOUND() {
        return LOCALIZER.localize(localizableERROR_JSONB_APPLICATION_NOT_FOUND());
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
