/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client.options;

import com.sun.jersey.api.client.ClientRequest;
import java.util.Arrays;
import org.gedcomx.rs.client.StateTransitionOption;

public class HeaderParameter
implements StateTransitionOption {
    public static final String LANG = "Accept-Language";
    public static final String LOCALE = "Accept-Language";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String IF_MATCH = "If-Match";
    public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public static final String PENDING_MODIFICATION = "X-FS-Feature-Tag";
    private final boolean replace;
    private final String name;
    private final String[] value;

    public HeaderParameter(String name, String ... value) {
        this(false, name, value);
    }

    public HeaderParameter(boolean replace, String name, String ... value) {
        String[] stringArray;
        this.replace = replace;
        this.name = name;
        if (value.length > 0) {
            stringArray = value;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        this.value = stringArray;
    }

    @Override
    public void apply(ClientRequest request) {
        if (this.replace) {
            request.getHeaders().put((Object)this.name, Arrays.asList(this.value));
        } else {
            for (String value : this.value) {
                request.getHeaders().add((Object)this.name, (Object)value);
            }
        }
    }

    public static HeaderParameter lang(String value) {
        return new HeaderParameter(true, "Accept-Language", value);
    }

    public static HeaderParameter locale(String value) {
        return new HeaderParameter(true, "Accept-Language", value);
    }
}

