/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client;

import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import javax.activation.DataSource;
import javax.ws.rs.core.MediaType;
import org.gedcomx.Gedcomx;
import org.gedcomx.conclusion.Person;
import org.gedcomx.links.Link;
import org.gedcomx.links.SupportsLinks;
import org.gedcomx.rs.client.CollectionState;
import org.gedcomx.rs.client.GedcomxApplicationState;
import org.gedcomx.rs.client.PersonState;
import org.gedcomx.rs.client.PersonsState;
import org.gedcomx.rs.client.StateFactory;
import org.gedcomx.rs.client.StateTransitionOption;
import org.gedcomx.source.SourceDescription;

public class SourceDescriptionState
extends GedcomxApplicationState<Gedcomx> {
    protected SourceDescriptionState(ClientRequest request, ClientResponse response, String accessToken, StateFactory stateFactory) {
        super(request, response, accessToken, stateFactory);
    }

    @Override
    public String getSelfRel() {
        return "description";
    }

    @Override
    protected SourceDescriptionState clone(ClientRequest request, ClientResponse response) {
        return new SourceDescriptionState(request, response, this.accessToken, this.stateFactory);
    }

    @Override
    public SourceDescriptionState ifSuccessful() {
        return (SourceDescriptionState)super.ifSuccessful();
    }

    @Override
    public SourceDescriptionState head(StateTransitionOption ... options) {
        return (SourceDescriptionState)super.head(options);
    }

    @Override
    public SourceDescriptionState options(StateTransitionOption ... options) {
        return (SourceDescriptionState)super.options(options);
    }

    @Override
    public SourceDescriptionState get(StateTransitionOption ... options) {
        return (SourceDescriptionState)super.get(options);
    }

    @Override
    public SourceDescriptionState delete(StateTransitionOption ... options) {
        return (SourceDescriptionState)super.delete(options);
    }

    public SourceDescriptionState put(Gedcomx e, StateTransitionOption ... options) {
        return (SourceDescriptionState)super.put(e, options);
    }

    public SourceDescriptionState post(Gedcomx entity, StateTransitionOption ... options) {
        return (SourceDescriptionState)super.post(entity, options);
    }

    @Override
    protected Gedcomx loadEntity(ClientResponse response) {
        return (Gedcomx)response.getEntity(Gedcomx.class);
    }

    @Override
    protected SupportsLinks getMainDataElement() {
        return this.getSourceDescription();
    }

    public SourceDescription getSourceDescription() {
        return this.getEntity() == null ? null : (((Gedcomx)this.getEntity()).getSourceDescriptions() == null ? null : (((Gedcomx)this.getEntity()).getSourceDescriptions().isEmpty() ? null : (SourceDescription)((Gedcomx)this.getEntity()).getSourceDescriptions().get(0)));
    }

    public SourceDescriptionState update(SourceDescription description, StateTransitionOption ... options) {
        Gedcomx entity = new Gedcomx();
        entity.setSourceDescriptions(Arrays.asList(description));
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)entity)).build(this.getSelfUri(), "POST");
        return this.stateFactory.newSourceDescriptionState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonsState readPersonas(StateTransitionOption ... options) {
        Link link = this.getLink("persons");
        if (link == null || link.getHref() == null) {
            return this.stateFactory.newPersonsState(this.request, this.response, this.accessToken);
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newPersonsState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState addPersona(Person person, StateTransitionOption ... options) {
        Gedcomx entity = new Gedcomx();
        entity.addPerson(person);
        return this.addPersona(entity, options);
    }

    public PersonState addPersona(Gedcomx entity, StateTransitionOption ... options) {
        URI target = this.getSelfUri();
        Link link = this.getLink("persons");
        if (link != null && link.getHref() != null) {
            target = link.getHref().toURI();
        }
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)entity)).build(target, "POST");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public SourceDescriptionState queryAttachedReferences(StateTransitionOption ... options) {
        Link link = this.getLink("source-references-query");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newSourceDescriptionState(request, this.invoke(request, options), this.accessToken);
    }

    public CollectionState readCollection(StateTransitionOption ... options) {
        Link link = this.getLink("collection");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newCollectionState(request, this.invoke(request, options), this.accessToken);
    }

    public SourceDescriptionState updateArtifact(DataSource artifact, StateTransitionOption ... options) {
        InputStream inputStream;
        Link link = this.getLink("artifact");
        if (link == null || link.getHref() == null) {
            return null;
        }
        FormDataMultiPart multiPart = new FormDataMultiPart();
        String mediaType = artifact.getContentType();
        if (mediaType == null) {
            mediaType = "application/octet-stream";
        }
        try {
            inputStream = artifact.getInputStream();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        FormDataContentDisposition.FormDataContentDispositionBuilder cd = FormDataContentDisposition.name((String)"artifact");
        if (artifact.getName() != null) {
            cd = (FormDataContentDisposition.FormDataContentDispositionBuilder)cd.fileName(artifact.getName());
        }
        FormDataBodyPart artifactPart = new FormDataBodyPart(cd.build(), (Object)inputStream, MediaType.valueOf((String)mediaType));
        multiPart.getBodyParts().add(artifactPart);
        ClientRequest request = ((ClientRequest.Builder)((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().type(MediaType.MULTIPART_FORM_DATA_TYPE)).entity((Object)multiPart)).build(link.getHref().toURI(), "POST");
        return this.stateFactory.newSourceDescriptionState(request, this.invoke(request, options), this.accessToken);
    }
}

