/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client;

import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.util.List;
import org.gedcomx.Gedcomx;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Relationship;
import org.gedcomx.links.Link;
import org.gedcomx.links.SupportsLinks;
import org.gedcomx.rs.client.CollectionState;
import org.gedcomx.rs.client.GedcomxApplicationState;
import org.gedcomx.rs.client.PersonState;
import org.gedcomx.rs.client.RelationshipState;
import org.gedcomx.rs.client.StateFactory;
import org.gedcomx.rs.client.StateTransitionOption;
import org.gedcomx.types.RelationshipType;

public class RelationshipsState
extends GedcomxApplicationState<Gedcomx> {
    protected RelationshipsState(ClientRequest request, ClientResponse response, String accessToken, StateFactory stateFactory) {
        super(request, response, accessToken, stateFactory);
    }

    @Override
    protected RelationshipsState clone(ClientRequest request, ClientResponse response) {
        return new RelationshipsState(request, response, this.accessToken, this.stateFactory);
    }

    @Override
    public RelationshipsState ifSuccessful() {
        return (RelationshipsState)super.ifSuccessful();
    }

    @Override
    public RelationshipsState head(StateTransitionOption ... options) {
        return (RelationshipsState)super.head(options);
    }

    @Override
    public RelationshipsState options(StateTransitionOption ... options) {
        return (RelationshipsState)super.options(options);
    }

    @Override
    public RelationshipsState get(StateTransitionOption ... options) {
        return (RelationshipsState)super.get(options);
    }

    @Override
    public RelationshipsState delete(StateTransitionOption ... options) {
        return (RelationshipsState)super.delete(options);
    }

    public RelationshipsState put(Gedcomx e, StateTransitionOption ... options) {
        return (RelationshipsState)super.put(e, options);
    }

    public RelationshipsState post(Gedcomx entity, StateTransitionOption ... options) {
        return (RelationshipsState)super.post(entity, options);
    }

    @Override
    protected Gedcomx loadEntity(ClientResponse response) {
        return (Gedcomx)response.getEntity(Gedcomx.class);
    }

    public List<Relationship> getRelationships() {
        return this.getEntity() == null ? null : ((Gedcomx)this.getEntity()).getRelationships();
    }

    @Override
    protected SupportsLinks getMainDataElement() {
        return (SupportsLinks)this.getEntity();
    }

    @Override
    public RelationshipsState readNextPage(StateTransitionOption ... options) {
        return (RelationshipsState)super.readNextPage(options);
    }

    @Override
    public RelationshipsState readPreviousPage(StateTransitionOption ... options) {
        return (RelationshipsState)super.readPreviousPage(options);
    }

    @Override
    public RelationshipsState readFirstPage(StateTransitionOption ... options) {
        return (RelationshipsState)super.readFirstPage(options);
    }

    @Override
    public RelationshipsState readLastPage(StateTransitionOption ... options) {
        return (RelationshipsState)super.readLastPage(options);
    }

    public CollectionState readCollection(StateTransitionOption ... options) {
        Link link = this.getLink("collection");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newCollectionState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState addSpouseRelationship(PersonState person1, PersonState person2, StateTransitionOption ... options) {
        Relationship relationship = new Relationship();
        relationship.setPerson1(new ResourceReference(new URI(person1.getSelfUri().toString())));
        relationship.setPerson2(new ResourceReference(new URI(person2.getSelfUri().toString())));
        relationship.setKnownType(RelationshipType.Couple);
        return this.addRelationship(relationship, options);
    }

    public RelationshipState addParentChildRelationship(PersonState parent, PersonState child, StateTransitionOption ... options) {
        Relationship relationship = new Relationship();
        relationship.setPerson1(new ResourceReference(new URI(parent.getSelfUri().toString())));
        relationship.setPerson2(new ResourceReference(new URI(child.getSelfUri().toString())));
        relationship.setKnownType(RelationshipType.ParentChild);
        return this.addRelationship(relationship, options);
    }

    public RelationshipState addRelationship(Relationship relationship, StateTransitionOption ... options) {
        Gedcomx entity = new Gedcomx();
        entity.addRelationship(relationship);
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)entity)).build(this.getSelfUri(), "POST");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }
}

