/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client;

import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.List;
import org.gedcomx.Gedcomx;
import org.gedcomx.links.Link;
import org.gedcomx.links.SupportsLinks;
import org.gedcomx.rs.client.GedcomxApplicationState;
import org.gedcomx.rs.client.PersonState;
import org.gedcomx.rs.client.StateFactory;
import org.gedcomx.rs.client.StateTransitionOption;
import org.gedcomx.rs.client.util.DescendancyTree;

public class DescendancyResultsState<E>
extends GedcomxApplicationState<Gedcomx> {
    protected DescendancyResultsState(ClientRequest request, ClientResponse response, String accessToken, StateFactory stateFactory) {
        super(request, response, accessToken, stateFactory);
    }

    @Override
    protected DescendancyResultsState clone(ClientRequest request, ClientResponse response) {
        return new DescendancyResultsState<E>(request, response, this.accessToken, this.stateFactory);
    }

    @Override
    protected Gedcomx loadEntity(ClientResponse response) {
        return (Gedcomx)response.getEntity(Gedcomx.class);
    }

    @Override
    public Gedcomx getEntity() {
        return (Gedcomx)super.getEntity();
    }

    @Override
    public DescendancyResultsState head(StateTransitionOption ... options) {
        return (DescendancyResultsState)super.head(options);
    }

    @Override
    public DescendancyResultsState options(StateTransitionOption ... options) {
        return (DescendancyResultsState)super.options(options);
    }

    @Override
    public DescendancyResultsState get(StateTransitionOption ... options) {
        return (DescendancyResultsState)super.get(options);
    }

    @Override
    public DescendancyResultsState delete(StateTransitionOption ... options) {
        return (DescendancyResultsState)super.delete(options);
    }

    public DescendancyResultsState put(Gedcomx e, StateTransitionOption ... options) {
        return (DescendancyResultsState)super.put(e, options);
    }

    public DescendancyResultsState post(Gedcomx entity, StateTransitionOption ... options) {
        return (DescendancyResultsState)super.post(entity, options);
    }

    @Override
    public DescendancyResultsState ifSuccessful() {
        return (DescendancyResultsState)super.ifSuccessful();
    }

    @Override
    protected SupportsLinks getMainDataElement() {
        return this.getEntity();
    }

    public DescendancyTree getTree() {
        return this.getEntity() != null ? new DescendancyTree(this.getEntity()) : null;
    }

    public PersonState readPerson(String descendantNumber, StateTransitionOption ... options) {
        URI personUri;
        int[] indexes;
        try {
            String[] indexStrings = descendantNumber.split("\\.");
            indexes = new int[indexStrings.length];
            for (int i = 0; i < indexStrings.length; ++i) {
                indexes[i] = Integer.parseInt(indexStrings[i]);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        DescendancyResultsState descendancyResultsState = this;
        DescendancyTree.DescendancyNode descendancyNode = descendancyResultsState.getTree().getRoot();
        if (indexes[0] != 1) {
            return null;
        }
        for (int i = 1; i < indexes.length; ++i) {
            int childNumber = indexes[i];
            List<DescendancyTree.DescendancyNode> descendantChildren = descendancyNode.getChildren();
            if (null == descendantChildren) {
                return null;
            }
            if (childNumber > descendantChildren.size() || childNumber < 0) {
                return null;
            }
            descendancyNode = descendantChildren.get(childNumber - 1);
        }
        Link selfLink = descendancyNode.getPerson().getLink("person");
        if (selfLink == null || selfLink.getHref() == null) {
            selfLink = descendancyNode.getPerson().getLink("self");
        }
        URI uRI = personUri = selfLink == null || selfLink.getHref() == null ? null : selfLink.getHref().toURI();
        if (personUri == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(personUri, "GET");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }
}

