/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client;

import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.util.List;
import org.gedcomx.Gedcomx;
import org.gedcomx.links.Link;
import org.gedcomx.links.SupportsLinks;
import org.gedcomx.records.Collection;
import org.gedcomx.rs.client.CollectionState;
import org.gedcomx.rs.client.GedcomxApplicationException;
import org.gedcomx.rs.client.GedcomxApplicationState;
import org.gedcomx.rs.client.StateFactory;
import org.gedcomx.rs.client.StateTransitionOption;
import org.gedcomx.source.SourceDescription;

public class CollectionsState
extends GedcomxApplicationState<Gedcomx> {
    protected CollectionsState(ClientRequest request, ClientResponse response, String accessToken, StateFactory stateFactory) {
        super(request, response, accessToken, stateFactory);
    }

    @Override
    protected CollectionsState clone(ClientRequest request, ClientResponse response) {
        return new CollectionsState(request, response, this.accessToken, this.stateFactory);
    }

    @Override
    public CollectionsState ifSuccessful() {
        return (CollectionsState)super.ifSuccessful();
    }

    @Override
    protected Gedcomx loadEntity(ClientResponse response) {
        return (Gedcomx)response.getEntity(Gedcomx.class);
    }

    @Override
    protected SupportsLinks getMainDataElement() {
        return (SupportsLinks)this.getEntity();
    }

    @Override
    public CollectionsState head(StateTransitionOption ... options) {
        return (CollectionsState)super.head(options);
    }

    @Override
    public CollectionsState options(StateTransitionOption ... options) {
        return (CollectionsState)super.options(options);
    }

    @Override
    public CollectionsState get(StateTransitionOption ... options) {
        return (CollectionsState)super.get(options);
    }

    @Override
    public CollectionsState delete(StateTransitionOption ... options) {
        return (CollectionsState)super.delete(options);
    }

    public CollectionsState put(Gedcomx e, StateTransitionOption ... options) {
        return (CollectionsState)super.put(e, options);
    }

    public CollectionsState post(Gedcomx entity, StateTransitionOption ... options) {
        return (CollectionsState)super.post(entity, options);
    }

    public List<Collection> getCollections() {
        return this.entity == null ? null : ((Gedcomx)this.entity).getCollections();
    }

    public List<SourceDescription> getSourceDescriptions() {
        return this.entity == null ? null : ((Gedcomx)this.entity).getSourceDescriptions();
    }

    public CollectionState readCollection(Collection collection, StateTransitionOption ... options) {
        Link link = collection.getLink("self");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newCollectionState(request, this.invoke(request, options), this.accessToken);
    }

    public CollectionState updateCollection(Collection collection, StateTransitionOption ... options) {
        Link link = collection.getLink("self");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "POST");
        return this.stateFactory.newCollectionState(request, this.invoke(request, options), this.accessToken);
    }

    public CollectionState readCollection(SourceDescription sourceDescription, StateTransitionOption ... options) {
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(sourceDescription.getAbout().toURI(), "GET");
        return this.stateFactory.newCollectionState(request, this.invoke(request, options), this.accessToken);
    }

    public CollectionState readCollection(StateTransitionOption ... options) {
        Link link = this.getLink("collection");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newCollectionState(request, this.invoke(request, options), this.accessToken);
    }

    public CollectionState addCollection(Collection collection, StateTransitionOption ... options) {
        return this.addCollection(collection, (SourceDescription)null, options);
    }

    public CollectionState addCollection(SourceDescription description, StateTransitionOption ... options) {
        return this.addCollection(null, description, options);
    }

    public CollectionState addCollection(Collection collection, SourceDescription sourceDescription, StateTransitionOption ... options) {
        Link link = this.getLink("subcollections");
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException(String.format("Collection at %s doesn't support adding subcollections.", this.getUri()));
        }
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)new Gedcomx().collection(collection).sourceDescription(sourceDescription))).build(link.getHref().toURI(), "POST");
        return this.stateFactory.newCollectionState(request, this.invoke(request, options), this.accessToken);
    }

    @Override
    public CollectionState readNextPage(StateTransitionOption ... options) {
        return (CollectionState)super.readNextPage(options);
    }

    @Override
    public CollectionState readPreviousPage(StateTransitionOption ... options) {
        return (CollectionState)super.readPreviousPage(options);
    }

    @Override
    public CollectionState readFirstPage(StateTransitionOption ... options) {
        return (CollectionState)super.readFirstPage(options);
    }

    @Override
    public CollectionState readLastPage(StateTransitionOption ... options) {
        return (CollectionState)super.readLastPage(options);
    }
}

