/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.ejbca.cvc.AlgorithmUtil;
import org.ejbca.cvc.AuthorizationRole;
import org.ejbca.cvc.AuthorizationRoleEnum;
import org.ejbca.cvc.ByteField;
import org.ejbca.cvc.CVCPublicKey;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.GenericPublicKeyField;
import org.ejbca.cvc.OIDField;
import org.ejbca.cvc.PublicKeyEC;
import org.ejbca.cvc.PublicKeyRSA;
import org.ejbca.cvc.exception.ConstructionException;

public class KeyFactory {
    public static CVCPublicKey createInstance(PublicKey pubKey, String algorithmName, AuthorizationRole authRole) throws ConstructionException {
        if (pubKey instanceof CVCPublicKey) {
            return (CVCPublicKey)pubKey;
        }
        CVCPublicKey cvcPublicKey = null;
        OIDField oid = AlgorithmUtil.getOIDField(algorithmName);
        if (oid.getValue().startsWith("0.4.0.127.0.7.2.2.2.1")) {
            cvcPublicKey = new PublicKeyRSA(oid, (RSAPublicKey)pubKey);
        } else if (oid.getValue().startsWith("0.4.0.127.0.7.2.2.2.2")) {
            cvcPublicKey = new PublicKeyEC(oid, (ECPublicKey)pubKey, authRole);
        } else {
            throw new IllegalArgumentException("Unknown key type: " + oid);
        }
        return cvcPublicKey;
    }

    public static CVCPublicKey createInstance(PublicKey pubKey, String algorithmName, AuthorizationRoleEnum authRole) throws ConstructionException {
        return KeyFactory.createInstance(pubKey, algorithmName, (AuthorizationRole)authRole);
    }

    static CVCPublicKey createInstance(GenericPublicKeyField genericKey) throws ConstructionException {
        CVCPublicKey cvcPublicKey;
        block4: {
            cvcPublicKey = null;
            try {
                OIDField oid = (OIDField)genericKey.getOptionalSubfield(CVCTagEnum.OID);
                if (oid.getValue().startsWith("0.4.0.127.0.7.2.2.2.1")) {
                    KeyFactory.copyField(CVCTagEnum.COEFFICIENT_A, CVCTagEnum.EXPONENT, genericKey);
                    cvcPublicKey = new PublicKeyRSA(genericKey);
                    break block4;
                }
                if (oid.getValue().startsWith("0.4.0.127.0.7.2.2.2.2")) {
                    KeyFactory.copyField(CVCTagEnum.EXPONENT, CVCTagEnum.COEFFICIENT_A, genericKey);
                    cvcPublicKey = new PublicKeyEC(genericKey);
                    break block4;
                }
                throw new IllegalArgumentException("Unknown public key OID: " + oid.getValue());
            }
            catch (NoSuchFieldException e) {
                throw new ConstructionException(e);
            }
        }
        return cvcPublicKey;
    }

    private static void copyField(CVCTagEnum fromTag, CVCTagEnum toTag, GenericPublicKeyField generic) throws ConstructionException {
        if (fromTag.getValue() != toTag.getValue()) {
            throw new IllegalArgumentException("Tag values are not equal");
        }
        ByteField field = (ByteField)generic.getOptionalSubfield(toTag);
        if (field == null && (field = (ByteField)generic.getOptionalSubfield(fromTag)) != null) {
            generic.addSubfield(new ByteField(toTag, field.getData()));
        }
    }
}

