/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import org.ejbca.cvc.AbstractSequence;
import org.ejbca.cvc.AlgorithmUtil;
import org.ejbca.cvc.ByteField;
import org.ejbca.cvc.CAReferenceField;
import org.ejbca.cvc.CVCPublicKey;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.CVCertificate;
import org.ejbca.cvc.Signable;
import org.ejbca.cvc.exception.ConstructionException;
import org.ejbca.cvc.util.BCECUtil;

public class CVCAuthenticatedRequest
extends AbstractSequence
implements Signable {
    private static final long serialVersionUID = 1L;
    private static CVCTagEnum[] allowedFields = new CVCTagEnum[]{CVCTagEnum.CV_CERTIFICATE, CVCTagEnum.CA_REFERENCE, CVCTagEnum.SIGNATURE};

    @Override
    protected CVCTagEnum[] getAllowedFields() {
        return allowedFields;
    }

    CVCAuthenticatedRequest() {
        super(CVCTagEnum.REQ_AUTHENTICATION);
    }

    public CVCAuthenticatedRequest(CVCertificate cvcert, CAReferenceField caReference) throws ConstructionException {
        this();
        this.addSubfield(cvcert);
        this.addSubfield(caReference);
    }

    public void setSignature(byte[] signatureData) throws ConstructionException {
        this.addSubfield(new ByteField(CVCTagEnum.SIGNATURE, signatureData));
    }

    @Override
    public byte[] getTBS() throws ConstructionException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            CVCertificate cert = this.getRequest();
            cert.encode(dout);
            CAReferenceField caref = this.getAuthorityReference();
            caref.encode(dout);
            dout.close();
            byte[] res = bout.toByteArray();
            return res;
        }
        catch (NoSuchFieldException e) {
            throw new ConstructionException(e);
        }
        catch (IOException e) {
            throw new ConstructionException(e);
        }
    }

    public CVCertificate getRequest() throws NoSuchFieldException {
        return (CVCertificate)this.getSubfield(CVCTagEnum.CV_CERTIFICATE);
    }

    public CAReferenceField getAuthorityReference() throws NoSuchFieldException {
        return (CAReferenceField)this.getSubfield(CVCTagEnum.CA_REFERENCE);
    }

    public byte[] getSignature() throws NoSuchFieldException {
        return ((ByteField)this.getSubfield(CVCTagEnum.SIGNATURE)).getData();
    }

    public void verify(PublicKey pubKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            CVCPublicKey cvcKey;
            String algorithm = "";
            if (pubKey instanceof CVCPublicKey) {
                cvcKey = (CVCPublicKey)pubKey;
                algorithm = AlgorithmUtil.getAlgorithmName(cvcKey.getObjectIdentifier());
            } else {
                cvcKey = this.getRequest().getCertificateBody().getPublicKey();
                algorithm = AlgorithmUtil.getAlgorithmName(cvcKey.getObjectIdentifier());
            }
            Signature sign = Signature.getInstance(algorithm, "BC");
            sign.initVerify(pubKey);
            sign.update(this.getTBS());
            byte[] sig = BCECUtil.convertCVCSigToX962(algorithm, this.getSignature());
            if (!sign.verify(sig)) {
                throw new SignatureException("Signature verification failed!");
            }
        }
        catch (NoSuchFieldException e) {
            throw new CertificateException("CV-Certificate is corrupt", e);
        }
        catch (ConstructionException e) {
            throw new CertificateException("CV-Certificate is corrupt", e);
        }
    }

    public String toString() {
        return this.getAsText("", true);
    }
}

