/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import org.ejbca.cvc.AuthorizationRole;

public enum AuthorizationRoleEnum implements AuthorizationRole
{
    CVCA(192),
    DV_D(128),
    DV_F(64),
    IS(0);

    private byte value;

    private AuthorizationRoleEnum(int value) {
        this.value = (byte)value;
    }

    @Override
    public byte getValue() {
        return this.value;
    }

    @Override
    public boolean isCVCA() {
        return this == CVCA;
    }

    @Override
    public boolean isDV() {
        return this == DV_D || this == DV_F;
    }

    @Override
    public boolean isDomesticDV() {
        return this == DV_D;
    }

    @Override
    public boolean isForeignDV() {
        return this == DV_F;
    }

    @Override
    public boolean isAccreditationBodyDV() {
        return false;
    }

    @Override
    public boolean isCertificationServiceProviderDV() {
        return false;
    }

    @Override
    public boolean isIS() {
        return this == IS;
    }

    @Override
    public boolean isAuthenticationTerminal() {
        return false;
    }

    @Override
    public boolean isSignatureTerminal() {
        return false;
    }

    public String toString() {
        switch (this) {
            case CVCA: {
                return "CVCA";
            }
            case DV_D: {
                return "DV-domestic";
            }
            case DV_F: {
                return "DV-foreign";
            }
            case IS: {
                return "IS";
            }
        }
        throw new IllegalStateException("Enum case not handled");
    }
}

