/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.loaderwriter;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.ehcache.Cache;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.Ehcache;
import org.ehcache.core.exceptions.ExceptionFactory;
import org.ehcache.core.exceptions.StorePassThroughException;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.WrapperStore;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.core.util.CollectionUtil;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.impl.internal.store.loaderwriter.LoaderWriterValueHolder;
import org.ehcache.spi.loaderwriter.BulkCacheLoadingException;
import org.ehcache.spi.loaderwriter.BulkCacheWritingException;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.resilience.StoreAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.context.ContextManager;

public class LocalLoaderWriterStore<K, V>
implements WrapperStore<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(LocalLoaderWriterStore.class);
    private static final Supplier<Boolean> SUPPLY_FALSE = () -> Boolean.FALSE;
    private final Store<K, V> delegate;
    private final CacheLoaderWriter<? super K, V> cacheLoaderWriter;
    private final boolean useLoaderInAtomics;
    private final ExpiryPolicy<? super K, ? super V> expiry;

    public LocalLoaderWriterStore(Store<K, V> delegate, CacheLoaderWriter<? super K, V> cacheLoaderWriter, boolean useLoaderInAtomics, ExpiryPolicy<? super K, ? super V> expiry) {
        this.delegate = delegate;
        this.cacheLoaderWriter = cacheLoaderWriter;
        this.useLoaderInAtomics = useLoaderInAtomics;
        this.expiry = expiry;
        ContextManager.associate(delegate).withParent((Object)this);
    }

    public Store.ValueHolder<V> get(K key) throws StoreAccessException {
        Function<Object, Object> mappingFunction = k -> {
            try {
                return this.cacheLoaderWriter.load(k);
            }
            catch (Exception e) {
                throw new StorePassThroughException((Throwable)ExceptionFactory.newCacheLoadingException((Exception)e));
            }
        };
        return this.delegate.computeIfAbsent(key, mappingFunction);
    }

    public boolean containsKey(K key) throws StoreAccessException {
        return this.delegate.containsKey(key);
    }

    public Store.PutStatus put(K key, V value) throws StoreAccessException {
        BiFunction<Object, Object, Object> remappingFunction = (key1, previousValue) -> {
            try {
                this.cacheLoaderWriter.write(key1, value);
            }
            catch (Exception e) {
                throw new StorePassThroughException((Throwable)ExceptionFactory.newCacheWritingException((Exception)e));
            }
            return value;
        };
        this.delegate.getAndCompute(key, remappingFunction);
        return Store.PutStatus.PUT;
    }

    public Store.ValueHolder<V> putIfAbsent(K key, V value, Consumer<Boolean> put) throws StoreAccessException {
        Function<Object, Object> mappingFunction = k -> {
            if (this.useLoaderInAtomics) {
                try {
                    Object loaded = this.cacheLoaderWriter.load(k);
                    if (loaded != null) {
                        return loaded;
                    }
                }
                catch (Exception e) {
                    throw new StorePassThroughException((Throwable)ExceptionFactory.newCacheLoadingException((Exception)e));
                }
            }
            try {
                this.cacheLoaderWriter.write(k, value);
            }
            catch (Exception e) {
                throw new StorePassThroughException((Throwable)ExceptionFactory.newCacheWritingException((Exception)e));
            }
            put.accept(true);
            return value;
        };
        return this.delegate.computeIfAbsent(key, mappingFunction);
    }

    public boolean remove(K key) throws StoreAccessException {
        boolean[] modified = new boolean[]{false};
        BiFunction<Object, Object, Object> remappingFunction = (key1, previousValue) -> {
            modified[0] = previousValue != null;
            try {
                this.cacheLoaderWriter.delete(key1);
            }
            catch (Exception e) {
                throw new StorePassThroughException((Throwable)ExceptionFactory.newCacheWritingException((Exception)e));
            }
            return null;
        };
        this.delegate.getAndCompute(key, remappingFunction);
        return modified[0];
    }

    public Store.RemoveStatus remove(K key, V value) throws StoreAccessException {
        boolean[] hitRemoved = new boolean[]{false, false};
        BiFunction<Object, Object, Object> remappingFunction = (k, inCache) -> {
            if ((inCache = this.loadFromLoaderWriter(key, inCache)) == null) {
                return null;
            }
            hitRemoved[0] = true;
            if (value.equals(inCache)) {
                try {
                    this.cacheLoaderWriter.delete(k);
                }
                catch (Exception e) {
                    throw new StorePassThroughException((Throwable)ExceptionFactory.newCacheWritingException((Exception)e));
                }
                hitRemoved[1] = true;
                return null;
            }
            return inCache;
        };
        this.delegate.computeAndGet(key, remappingFunction, SUPPLY_FALSE, SUPPLY_FALSE);
        if (hitRemoved[1]) {
            return Store.RemoveStatus.REMOVED;
        }
        if (hitRemoved[0]) {
            return Store.RemoveStatus.KEY_PRESENT;
        }
        return Store.RemoveStatus.KEY_MISSING;
    }

    public Store.ValueHolder<V> replace(K key, V value) throws StoreAccessException {
        Object[] old = new Object[1];
        BiFunction<Object, Object, Object> remappingFunction = (k, inCache) -> {
            if ((inCache = this.loadFromLoaderWriter(key, inCache)) == null) {
                return null;
            }
            try {
                this.cacheLoaderWriter.write(key, value);
            }
            catch (Exception e) {
                throw new StorePassThroughException((Throwable)ExceptionFactory.newCacheWritingException((Exception)e));
            }
            old[0] = inCache;
            if (LocalLoaderWriterStore.newValueAlreadyExpired(LOG, this.expiry, key, inCache, value)) {
                return null;
            }
            return value;
        };
        this.delegate.getAndCompute(key, remappingFunction);
        if (old[0] == null) {
            return null;
        }
        return new LoaderWriterValueHolder<Object>(old[0]);
    }

    public Store.ReplaceStatus replace(K key, V oldValue, V newValue) throws StoreAccessException {
        boolean[] successHit = new boolean[]{false, false};
        BiFunction<Object, Object, Object> remappingFunction = (k, inCache) -> {
            if ((inCache = this.loadFromLoaderWriter(key, inCache)) == null) {
                return null;
            }
            successHit[1] = true;
            if (oldValue.equals(inCache)) {
                try {
                    this.cacheLoaderWriter.write(key, newValue);
                }
                catch (Exception e) {
                    throw new StorePassThroughException((Throwable)ExceptionFactory.newCacheWritingException((Exception)e));
                }
                successHit[0] = true;
                if (LocalLoaderWriterStore.newValueAlreadyExpired(LOG, this.expiry, key, oldValue, newValue)) {
                    return null;
                }
                return newValue;
            }
            return inCache;
        };
        this.delegate.computeAndGet(key, remappingFunction, SUPPLY_FALSE, SUPPLY_FALSE);
        if (successHit[0]) {
            return Store.ReplaceStatus.HIT;
        }
        if (successHit[1]) {
            return Store.ReplaceStatus.MISS_PRESENT;
        }
        return Store.ReplaceStatus.MISS_NOT_PRESENT;
    }

    public void clear() throws StoreAccessException {
        this.delegate.clear();
    }

    public StoreEventSource<K, V> getStoreEventSource() {
        return this.delegate.getStoreEventSource();
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        return this.delegate.iterator();
    }

    public Store.ValueHolder<V> getAndCompute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws StoreAccessException {
        return this.delegate.getAndCompute(key, (mappedKey, mappedValue) -> {
            Object newValue = mappingFunction.apply((K)mappedKey, (V)mappedValue);
            if (newValue == null) {
                try {
                    this.cacheLoaderWriter.delete(mappedKey);
                }
                catch (Exception e) {
                    throw new StorePassThroughException((Throwable)ExceptionFactory.newCacheWritingException((Exception)e));
                }
                return null;
            }
            try {
                this.cacheLoaderWriter.write(mappedKey, newValue);
            }
            catch (Exception e) {
                throw new StorePassThroughException((Throwable)ExceptionFactory.newCacheWritingException((Exception)e));
            }
            if (LocalLoaderWriterStore.newValueAlreadyExpired(LOG, this.expiry, mappedKey, mappedValue, newValue)) {
                return null;
            }
            return newValue;
        });
    }

    public Store.ValueHolder<V> computeAndGet(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction, Supplier<Boolean> replaceEqual, Supplier<Boolean> invokeWriter) throws StoreAccessException {
        BiFunction<Object, Object, Object> remappingFunction = (mappedKey, mappedValue) -> {
            Object newValue = mappingFunction.apply((K)mappedKey, (V)mappedValue);
            if (((Boolean)invokeWriter.get()).booleanValue()) {
                try {
                    if (newValue != null) {
                        this.cacheLoaderWriter.write(mappedKey, newValue);
                    } else {
                        this.cacheLoaderWriter.delete(mappedKey);
                    }
                }
                catch (Exception e) {
                    throw new StorePassThroughException((Throwable)ExceptionFactory.newCacheWritingException((Exception)e));
                }
            }
            return newValue;
        };
        return this.delegate.computeAndGet(key, remappingFunction, replaceEqual, SUPPLY_FALSE);
    }

    public Store.ValueHolder<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) throws StoreAccessException {
        throw new UnsupportedOperationException("Not supported");
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws StoreAccessException {
        HashSet successes = new HashSet(1);
        HashMap failures = new HashMap(1);
        if (remappingFunction instanceof Ehcache.PutAllFunction) {
            return this.getkValueHolderMap((Ehcache.PutAllFunction)remappingFunction, successes, failures);
        }
        if (remappingFunction instanceof Ehcache.RemoveAllFunction) {
            return this.getkValueHolderMap(keys);
        }
        return this.delegate.bulkCompute(keys, remappingFunction);
    }

    private Map<K, Store.ValueHolder<V>> getkValueHolderMap(Set<? extends K> keys) throws StoreAccessException {
        HashSet deleteSuccesses = new HashSet(1);
        HashMap deleteFailures = new HashMap(1);
        HashMap<K, Object> entriesToRemove = new HashMap<K, Object>(keys.size());
        for (K key : keys) {
            entriesToRemove.put(key, null);
        }
        int[] actualRemoveCount = new int[]{0};
        Function<Iterable, Iterable> removalFunction = entries -> {
            Set<K> unknowns = this.cacheLoaderWriterDeleteAllCall((Iterable<? extends Map.Entry<? extends K, ? extends V>>)entries, (Map<K, ? extends V>)entriesToRemove, deleteSuccesses, deleteFailures);
            int size = CollectionUtil.findBestCollectionSize((Iterable)entries, (int)1);
            LinkedHashMap results = new LinkedHashMap(size);
            for (Map.Entry entry : entries) {
                Object key = entry.getKey();
                Object existingValue = entry.getValue();
                if (deleteSuccesses.contains(key)) {
                    if (existingValue != null) {
                        actualRemoveCount[0] = actualRemoveCount[0] + 1;
                    }
                    results.put(key, null);
                    entriesToRemove.remove(key);
                    continue;
                }
                if (unknowns.contains(key)) {
                    results.put(key, null);
                    continue;
                }
                results.put(key, existingValue);
            }
            return results.entrySet();
        };
        Map map = this.delegate.bulkCompute(keys, removalFunction);
        if (!deleteFailures.isEmpty()) {
            throw new BulkCacheWritingException(deleteFailures, deleteSuccesses);
        }
        return map;
    }

    private Map<K, Store.ValueHolder<V>> getkValueHolderMap(Ehcache.PutAllFunction<K, V> remappingFunction, Set<K> successes, Map<K, Exception> failures) throws StoreAccessException {
        Ehcache.PutAllFunction<K, V> putAllFunction = remappingFunction;
        Map entriesToRemap = CollectionUtil.copyMapButFailOnNull((Map)putAllFunction.getEntriesToRemap());
        int[] actualPutCount = new int[]{0};
        Function<Iterable, Iterable> computeFunction = entries1 -> {
            this.cacheLoaderWriterWriteAllCall((Iterable<? extends Map.Entry<? extends K, ? extends V>>)entries1, entriesToRemap, successes, failures);
            int size = CollectionUtil.findBestCollectionSize((Iterable)entries1, (int)1);
            LinkedHashMap mutations = new LinkedHashMap(size);
            for (Map.Entry entry : entries1) {
                Object newValue;
                Object existingValue;
                Object key = entry.getKey();
                if (LocalLoaderWriterStore.newValueAlreadyExpired(LOG, this.expiry, key, existingValue = entry.getValue(), newValue = entriesToRemap.remove(key))) {
                    mutations.put(key, null);
                    continue;
                }
                if (successes.contains(key)) {
                    actualPutCount[0] = actualPutCount[0] + 1;
                    mutations.put(key, newValue);
                    continue;
                }
                mutations.put(key, existingValue);
            }
            return mutations.entrySet();
        };
        Map computedMap = this.delegate.bulkCompute(putAllFunction.getEntriesToRemap().keySet(), computeFunction);
        if (!failures.isEmpty()) {
            throw new BulkCacheWritingException(failures, successes);
        }
        return computedMap;
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, Supplier<Boolean> replaceEqual) throws StoreAccessException {
        return null;
    }

    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws StoreAccessException {
        HashMap successes = new HashMap(1);
        HashMap failures = new HashMap(1);
        if (!(mappingFunction instanceof Ehcache.GetAllFunction)) {
            return this.delegate.bulkComputeIfAbsent(keys, mappingFunction);
        }
        Function<Iterable, Iterable> computeFunction = keys1 -> {
            Map loaded;
            try {
                loaded = this.cacheLoaderWriter.loadAll(keys1);
            }
            catch (BulkCacheLoadingException bcle) {
                loaded = Collections.emptyMap();
                this.collectSuccessesAndFailures(bcle, successes, failures);
            }
            catch (Exception e) {
                loaded = Collections.emptyMap();
                for (Object key : keys1) {
                    failures.put(key, e);
                }
            }
            int size = CollectionUtil.findBestCollectionSize((Iterable)keys1, (int)1);
            LinkedHashMap computeResult = new LinkedHashMap(size);
            for (Object key : keys1) {
                computeResult.put(key, null);
            }
            if (!loaded.isEmpty()) {
                for (Object key : keys1) {
                    Object value = loaded.get(key);
                    successes.put(key, value);
                    computeResult.put(key, value);
                }
            }
            return computeResult.entrySet();
        };
        HashMap result = new HashMap();
        Map computedMap = this.delegate.bulkComputeIfAbsent(keys, computeFunction);
        if (failures.isEmpty()) {
            return computedMap;
        }
        successes.putAll(result);
        throw new BulkCacheLoadingException(failures, successes);
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        return this.delegate.getConfigurationChangeListeners();
    }

    private V loadFromLoaderWriter(K key, V inCache) {
        block5: {
            if (inCache == null) {
                if (this.useLoaderInAtomics) {
                    try {
                        inCache = this.cacheLoaderWriter.load(key);
                        if (inCache == null) {
                            return null;
                        }
                        break block5;
                    }
                    catch (Exception e) {
                        throw new StorePassThroughException((Throwable)ExceptionFactory.newCacheLoadingException((Exception)e));
                    }
                }
                return null;
            }
        }
        return inCache;
    }

    private void cacheLoaderWriterWriteAllCall(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries, Map<K, V> entriesToRemap, Set<K> successes, Map<K, Exception> failures) throws IllegalStateException {
        block5: {
            HashMap<K, V> toWrite = new HashMap<K, V>();
            for (Map.Entry<K, V> entry : entries) {
                V value = entriesToRemap.get(entry.getKey());
                if (value == null) continue;
                toWrite.put(entry.getKey(), value);
            }
            try {
                if (toWrite.isEmpty()) break block5;
                this.cacheLoaderWriter.writeAll(toWrite.entrySet());
                successes.addAll(toWrite.keySet());
            }
            catch (BulkCacheWritingException bcwe) {
                LocalLoaderWriterStore.collectSuccessesAndFailures(bcwe, successes, failures);
            }
            catch (Exception e) {
                for (Object key : toWrite.keySet()) {
                    failures.put(key, e);
                }
            }
        }
    }

    private Set<K> cacheLoaderWriterDeleteAllCall(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries, Map<K, ? extends V> entriesToRemove, Set<K> successes, Map<K, Exception> failures) {
        HashSet<K> unknowns = new HashSet<K>();
        HashSet<K> toDelete = new HashSet<K>();
        for (Map.Entry<K, V> entry : entries) {
            Object key = entry.getKey();
            if (!entriesToRemove.containsKey(key)) continue;
            toDelete.add(key);
        }
        try {
            this.cacheLoaderWriter.deleteAll(toDelete);
            successes.addAll(toDelete);
        }
        catch (BulkCacheWritingException bcwe) {
            LocalLoaderWriterStore.collectSuccessesAndFailures(bcwe, successes, failures);
        }
        catch (Exception e) {
            for (Object key : toDelete) {
                failures.put(key, e);
                unknowns.add(key);
            }
        }
        return unknowns;
    }

    private static <K> void collectSuccessesAndFailures(BulkCacheWritingException bcwe, Set<K> successes, Map<K, Exception> failures) {
        successes.addAll(bcwe.getSuccesses());
        failures.putAll(bcwe.getFailures());
    }

    private void collectSuccessesAndFailures(BulkCacheLoadingException bcle, Map<K, V> successes, Map<K, Exception> failures) {
        successes.putAll(bcle.getSuccesses());
        failures.putAll(bcle.getFailures());
    }

    private static <K, V> boolean newValueAlreadyExpired(Logger logger, ExpiryPolicy<? super K, ? super V> expiry, K key, V oldValue, V newValue) {
        Duration duration;
        if (newValue == null) {
            return false;
        }
        try {
            duration = oldValue == null ? expiry.getExpiryForCreation(key, newValue) : expiry.getExpiryForUpdate(key, () -> oldValue, newValue);
        }
        catch (RuntimeException re) {
            logger.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
            return true;
        }
        return Duration.ZERO.equals(duration);
    }
}

