/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.build;

import io.fabric8.kubernetes.api.model.KubernetesList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.validation.ConstraintViolationException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.api.GeneratorManager;
import org.eclipse.jkube.kit.build.service.docker.config.handler.ImageConfigResolver;
import org.eclipse.jkube.kit.build.service.docker.helper.ConfigHelper;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.ResourceFileType;
import org.eclipse.jkube.kit.common.util.BuildReferenceDateUtil;
import org.eclipse.jkube.kit.common.util.DekorateUtil;
import org.eclipse.jkube.kit.common.util.LazyBuilder;
import org.eclipse.jkube.kit.common.util.MavenUtil;
import org.eclipse.jkube.kit.common.util.ResourceClassifier;
import org.eclipse.jkube.kit.common.util.ResourceUtil;
import org.eclipse.jkube.kit.common.util.validator.ResourceValidator;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.resource.EnricherManager;
import org.eclipse.jkube.kit.config.resource.MappingConfig;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ProcessorConfig;
import org.eclipse.jkube.kit.config.resource.ResourceServiceConfig;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;
import org.eclipse.jkube.kit.enricher.api.DefaultEnricherManager;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.kit.profile.ProfileUtil;
import org.eclipse.jkube.kit.resource.service.DefaultResourceService;
import org.eclipse.jkube.maven.plugin.mojo.build.AbstractJKubeMojo;

@Mojo(name="resource", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ResourceMojo
extends AbstractJKubeMojo {
    public static final String DOCKER_BUILD_TIMESTAMP = "docker/build.timestamp";
    @Parameter(property="jkube.targetDir", defaultValue="${project.build.outputDirectory}/META-INF/jkube")
    protected File targetDir;
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Component
    protected ImageConfigResolver imageConfigResolver;
    @Parameter(property="jkube.resourceDir", defaultValue="${basedir}/src/main/jkube")
    protected File resourceDir;
    @Parameter(property="jkube.environment")
    private String environment;
    @Parameter(property="jkube.useProjectClasspath", defaultValue="false")
    private boolean useProjectClasspath = false;
    @Parameter(property="jkube.workDir", defaultValue="${project.build.directory}/jkube")
    private File workDir;
    @Parameter(property="jkube.skipResourceValidation", defaultValue="false")
    protected Boolean skipResourceValidation;
    @Parameter(property="jkube.failOnValidationError", defaultValue="false")
    private Boolean failOnValidationError;
    @Parameter
    protected List<ImageConfiguration> images;
    @Parameter(property="jkube.profile")
    private String profile;
    @Parameter
    private ProcessorConfig enricher;
    @Parameter
    private ProcessorConfig generator;
    private boolean useReplicaSet = true;
    protected List<ImageConfiguration> resolvedImages;
    @Parameter
    private List<MappingConfig> mappings;
    @Parameter(property="jkube.skip.resource", defaultValue="false")
    protected boolean skipResource;
    @Parameter(property="jkube.resourceType")
    private ResourceFileType resourceFileType = ResourceFileType.yaml;
    @Parameter(property="jkube.mergeWithDekorate", defaultValue="false")
    private Boolean mergeWithDekorate;
    @Parameter(property="jkube.interpolateTemplateParameters", defaultValue="true")
    protected Boolean interpolateTemplateParameters;
    @Component
    protected MavenProjectHelper projectHelper;
    private List<File> realResourceDirs;

    @Override
    protected boolean shouldSkip() {
        return super.shouldSkip() || this.skipResource;
    }

    @Override
    public void executeInternal() throws MojoExecutionException, MojoFailureException {
        if (DekorateUtil.useDekorate((JavaProject)this.javaProject) && this.mergeWithDekorate.booleanValue()) {
            this.log.info("Dekorate detected, merging JKube and Dekorate resources", new Object[0]);
            System.setProperty("dekorate.input.dir", "META-INF/jkube");
            System.setProperty("dekorate.output.dir", "META-INF/jkube");
        } else if (DekorateUtil.useDekorate((JavaProject)this.javaProject)) {
            this.log.info("Dekorate detected, delegating resource build", new Object[0]);
            System.setProperty("dekorate.output.dir", "META-INF/jkube");
            return;
        }
        KubernetesResourceUtil.updateKindFilenameMappings(this.mappings);
        try {
            this.lateInit();
            this.resolvedImages = this.getResolvedImages(this.images, this.log);
            if (!(this.skip || this.isPomProject() && !this.hasJKubeDir())) {
                ResourceClassifier resourceClassifier = this.getResourceClassifier();
                KubernetesList resourceList = this.generateResources();
                File resourceClassifierDir = new File(this.targetDir, resourceClassifier.getValue());
                File artifact = this.jkubeServiceHub.getResourceService().writeResources(resourceList, resourceClassifier, this.log);
                this.validateIfRequired(resourceClassifierDir, resourceClassifier);
                this.projectHelper.attachArtifact(this.project, this.resourceFileType.getArtifactType(), resourceClassifier.getValue(), artifact);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate kubernetes descriptor", (Exception)e);
        }
    }

    @Override
    protected RuntimeMode getRuntimeMode() {
        return RuntimeMode.KUBERNETES;
    }

    @Override
    protected JKubeServiceHub.JKubeServiceHubBuilder initJKubeServiceHubBuilder(JavaProject javaProject) {
        this.realResourceDirs = ResourceUtil.getFinalResourceDirs((File)this.resourceDir, (String)this.environment);
        ResourceServiceConfig resourceServiceConfig = ResourceServiceConfig.builder().project(javaProject).resourceDirs(this.realResourceDirs).targetDir(this.targetDir).resourceFileType(this.resourceFileType).resourceConfig(this.resources).resourceFilesProcessor(resourceFiles -> this.mavenFilterFiles(resourceFiles, this.workDir)).interpolateTemplateParameters(this.interpolateTemplateParameters.booleanValue()).build();
        return super.initJKubeServiceHubBuilder(javaProject).resourceService(new LazyBuilder(() -> new DefaultResourceService(resourceServiceConfig)));
    }

    protected PlatformMode getPlatformMode() {
        return PlatformMode.kubernetes;
    }

    protected ResourceClassifier getResourceClassifier() {
        return ResourceClassifier.KUBERNETES;
    }

    private void validateIfRequired(File resourceDir, ResourceClassifier classifier) throws MojoExecutionException, MojoFailureException {
        try {
            if (!this.skipResourceValidation.booleanValue()) {
                new ResourceValidator(resourceDir, classifier, this.log).validate();
            }
        }
        catch (ConstraintViolationException e) {
            if (this.failOnValidationError.booleanValue()) {
                this.log.error("[[R]]" + e.getMessage() + "[[R]]", new Object[0]);
                this.log.error("[[R]]use \"mvn -Djkube.skipResourceValidation=true\" option to skip the validation[[R]]", new Object[0]);
                throw new MojoFailureException("Failed to generate kubernetes descriptor");
            }
            this.log.warn("[[Y]]" + e.getMessage() + "[[Y]]", new Object[0]);
        }
        catch (Exception e) {
            if (this.failOnValidationError.booleanValue()) {
                throw new MojoExecutionException("Failed to validate resources", e);
            }
            this.log.warn("Failed to validate resources: %s", new Object[]{e.getMessage()});
        }
    }

    private void lateInit() {
        RuntimeMode runtimeMode = this.getRuntimeMode();
        this.jkubeServiceHub.setPlatformMode(runtimeMode);
        if (runtimeMode.equals((Object)RuntimeMode.OPENSHIFT)) {
            Properties properties = this.javaProject.getProperties();
            if (!properties.contains("jkube.image.user")) {
                String namespaceToBeUsed = this.namespace != null && !this.namespace.isEmpty() ? this.namespace : this.clusterAccess.getNamespace();
                this.log.info("Using docker image name of namespace: " + namespaceToBeUsed, new Object[0]);
                properties.setProperty("jkube.image.user", namespaceToBeUsed);
            }
            if (!properties.contains("jkube.internal.effective.platform.mode")) {
                properties.setProperty("jkube.internal.effective.platform.mode", runtimeMode.toString());
            }
        }
    }

    private KubernetesList generateResources() throws IOException {
        JKubeEnricherContext.JKubeEnricherContextBuilder ctxBuilder = JKubeEnricherContext.builder().jKubeBuildStrategy(this.buildStrategy).project(this.javaProject).processorConfig(this.extractEnricherConfig()).settings((Collection)MavenUtil.getRegistryServerFromMavenSettings((Settings)this.settings)).resources(this.resources).images(this.resolvedImages).log(this.log);
        DefaultEnricherManager enricherManager = new DefaultEnricherManager((EnricherContext)ctxBuilder.build(), this.useProjectClasspath ? this.javaProject.getCompileClassPathElements() : Collections.emptyList());
        return this.jkubeServiceHub.getResourceService().generateResources(this.getPlatformMode(), (EnricherManager)enricherManager, this.log);
    }

    private ProcessorConfig extractEnricherConfig() throws IOException {
        return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.ENRICHER_CONFIG, (String)this.profile, this.realResourceDirs, (ProcessorConfig)this.enricher);
    }

    private ProcessorConfig extractGeneratorConfig() throws IOException {
        return ProfileUtil.blendProfileWithConfiguration((ProfileUtil.ProcessorConfigurationExtractor)ProfileUtil.GENERATOR_CONFIG, (String)this.profile, this.realResourceDirs, (ProcessorConfig)this.generator);
    }

    private List<ImageConfiguration> getResolvedImages(List<ImageConfiguration> images, KitLogger log) throws IOException {
        return ConfigHelper.initImageConfiguration(null, (Date)BuildReferenceDateUtil.getBuildTimestamp((Map)this.getPluginContext(), (String)"CONTEXT_KEY_BUILD_TIMESTAMP", (String)this.project.getBuild().getDirectory(), (String)DOCKER_BUILD_TIMESTAMP), images, (ImageConfigResolver)this.imageConfigResolver, (KitLogger)log, null, configs -> {
            try {
                GeneratorContext ctx = GeneratorContext.builder().config(this.extractGeneratorConfig()).project(this.javaProject).runtimeMode(this.getRuntimeMode()).logger(log).strategy(JKubeBuildStrategy.docker).useProjectClasspath(this.useProjectClasspath).build();
                return GeneratorManager.generate((List)configs, (GeneratorContext)ctx, (boolean)true);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot extract generator: " + e, e);
            }
        }, (JKubeConfiguration)this.jkubeServiceHub.getConfiguration());
    }

    private File[] mavenFilterFiles(File[] resourceFiles, File outDir) throws IOException {
        if (resourceFiles == null) {
            return new File[0];
        }
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new IOException("Cannot create working dir " + outDir);
        }
        File[] ret = new File[resourceFiles.length];
        int i = 0;
        for (File resource : resourceFiles) {
            File targetFile = new File(outDir, resource.getName());
            try {
                this.mavenFileFilter.copyFile(resource, targetFile, true, this.project, null, false, "utf8", this.session);
                ret[i++] = targetFile;
            }
            catch (MavenFilteringException exp) {
                throw new IOException(String.format("Cannot filter %s to %s", resource, targetFile), exp);
            }
        }
        return ret;
    }

    private boolean hasJKubeDir() {
        return !this.realResourceDirs.isEmpty() && this.realResourceDirs.get(0).isDirectory();
    }

    private boolean isPomProject() {
        return "pom".equals(this.project.getPackaging());
    }
}

