/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.nio.ByteBuffer;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.AsyncRequestContent;
import org.eclipse.jetty.reactive.client.ContentChunk;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.util.Callback;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class PublisherRequestContent
implements Request.Content,
Subscriber<ContentChunk> {
    private final AsyncRequestContent asyncContent = new AsyncRequestContent(new ByteBuffer[0]);
    private final ReactiveRequest.Content reactiveContent;
    private Subscription subscription;

    public PublisherRequestContent(ReactiveRequest.Content content) {
        this.reactiveContent = content;
        content.subscribe(this);
    }

    public long getLength() {
        return this.reactiveContent.getLength();
    }

    public String getContentType() {
        return this.reactiveContent.getContentType();
    }

    public Request.Content.Subscription subscribe(Request.Content.Consumer consumer, boolean emitInitialContent) {
        return this.asyncContent.subscribe(consumer, emitInitialContent);
    }

    public void fail(Throwable failure) {
        this.onError(failure);
    }

    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    public void onNext(ContentChunk chunk) {
        this.asyncContent.offer(chunk.buffer, (Callback)new Callback.Nested(chunk.callback){

            public void succeeded() {
                super.succeeded();
                PublisherRequestContent.this.subscription.request(1L);
            }

            public void failed(Throwable x) {
                super.failed(x);
                PublisherRequestContent.this.subscription.cancel();
            }
        });
    }

    public void onError(Throwable failure) {
        this.asyncContent.fail(failure);
    }

    public void onComplete() {
        this.asyncContent.close();
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

