/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cyclonedx.model.Source;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"id", "name", "description", "source", "references"})
public class Issue {
    private String id;
    private String name;
    private String description;
    private Source source;
    private List<String> references;
    @JacksonXmlProperty(isAttribute=true)
    private Type type;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    @JacksonXmlElementWrapper(localName="references")
    @JacksonXmlProperty(localName="url")
    public List<String> getReferences() {
        return this.references;
    }

    public void addReference(String reference) {
        if (this.references == null) {
            this.references = new ArrayList<String>();
        }
        this.references.add(reference);
    }

    public void addReference(URI reference) {
        if (this.references == null) {
            this.references = new ArrayList<String>();
        }
        this.references.add(reference.toString());
    }

    public void setReferences(List<String> references) {
        this.references = references;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Issue)) {
            return false;
        }
        Issue issue = (Issue)object;
        return Objects.equals(this.id, issue.id) && Objects.equals(this.name, issue.name) && Objects.equals(this.description, issue.description) && Objects.equals(this.source, issue.source) && Objects.equals(this.references, issue.references) && this.type == issue.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.source, this.references, this.type});
    }

    public static enum Type {
        ENHANCEMENT("enhancement"),
        SECURITY("security"),
        DEFECT("defect");

        private final String name;

        public String getTypeName() {
            return this.name;
        }

        private Type(String name) {
            this.name = name;
        }
    }
}

