/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cyclonedx.model.BomReference;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Dependency
extends BomReference {
    @JsonProperty(value="dependsOn")
    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="dependency")
    private List<Dependency> dependencies;

    public Dependency(String ref) {
        super(ref);
    }

    public Dependency() {
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public void addDependency(Dependency dependency) {
        boolean found;
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<Dependency>();
        }
        if (!(found = this.dependencies.stream().anyMatch(d -> d.getRef().equals(dependency.getRef())))) {
            this.dependencies.add(dependency);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dependency)) {
            return false;
        }
        Dependency that = (Dependency)o;
        return Objects.equals(this.getRef(), that.getRef());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getRef());
    }
}

