/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.gradle.plugins.locc.reports;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.cthing.gradle.plugins.locc.CountsCache;
import org.cthing.gradle.plugins.locc.reports.AbstractLoccReport;
import org.cthing.locc4j.Counts;
import org.cthing.locc4j.Language;
import org.cthing.xmlwriter.XmlWriter;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.TaskExecutionException;
import org.jspecify.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class XmlReport
extends AbstractLoccReport {
    private static final int FORMAT_VERSION = 1;
    private static final String NAMESPACE = "http://www.cthing.com/locc";
    private static final String SCHEMA_FILENAME = "locc-1.xsd";
    private static final String SCHEMA_URL = "https://www.cthing.com/schemas/locc-1.xsd";
    private @Nullable Counts totalCounts;

    @Inject
    public XmlReport(Task task, DirectoryProperty reportsDir) {
        super(task, "xml", "Report in XML format", true);
        this.getOutputLocation().value(reportsDir.file("locc.xml"));
    }

    @Override
    public void generateReport(CountsCache countsCache) {
        this.totalCounts = countsCache.getTotalCounts();
        File destination = (File)this.getOutputLocation().getAsFile().get();
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(destination.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            XmlWriter xmlWriter = new XmlWriter((Writer)writer);
            xmlWriter.setPrettyPrint(true);
            xmlWriter.startDocument();
            xmlWriter.addNSPrefix("", NAMESPACE);
            AttributesImpl attrs = new AttributesImpl();
            this.addAttribute(attrs, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.addAttribute(attrs, "xsi:schemaLocation", "https://www.cthing.com/schemas/locc-1.xsd locc-1.xsd");
            this.addAttribute(attrs, "formatVersion", 1);
            this.addAttribute(attrs, "date", this.timestamp());
            this.addAttribute(attrs, "projectName", this.task.getProject().getName());
            this.addAttribute(attrs, "projectVersion", this.task.getProject().getVersion().toString());
            xmlWriter.startElement(NAMESPACE, "locc", (Attributes)attrs);
            this.writeLanguages(xmlWriter, countsCache);
            this.writeFiles(xmlWriter, countsCache);
            xmlWriter.endElement();
            xmlWriter.endDocument();
        }
        catch (IOException | SAXException ex) {
            throw new TaskExecutionException(this.task, (Throwable)ex);
        }
    }

    private void writeLanguages(XmlWriter xmlWriter, CountsCache countsCache) throws SAXException {
        assert (this.totalCounts != null);
        Map<Language, Counts> langCounts = countsCache.getLanguageCounts();
        AttributesImpl langsAttrs = new AttributesImpl();
        this.addAttribute(langsAttrs, "numLanguages", langCounts.size());
        this.addCountAttributes(langsAttrs, this.totalCounts);
        xmlWriter.startElement(NAMESPACE, "languages", (Attributes)langsAttrs);
        ArrayList<Language> languages = new ArrayList<Language>(langCounts.keySet());
        languages.sort(Comparator.comparing(Language::getDisplayName));
        for (Language language : languages) {
            this.writeLanguage(xmlWriter, language, langCounts.get(language));
        }
        xmlWriter.endElement();
    }

    private void writeFiles(XmlWriter xmlWriter, CountsCache countsCache) throws SAXException {
        assert (this.totalCounts != null);
        int numFiles = countsCache.getPathCounts().size();
        Set<Path> unrecognized = countsCache.getUnrecognized();
        AttributesImpl filesAttrs = new AttributesImpl();
        this.addAttribute(filesAttrs, "numFiles", numFiles);
        this.addAttribute(filesAttrs, "numUnrecognized", unrecognized.size());
        this.addCountAttributes(filesAttrs, this.totalCounts);
        xmlWriter.startElement(NAMESPACE, "files", (Attributes)filesAttrs);
        Map<Path, Counts> pathTotals = countsCache.getFileCounts();
        ArrayList<Path> paths = new ArrayList<Path>(countsCache.getPathCounts().keySet());
        paths.sort(Path::compareTo);
        for (Path path : paths) {
            Map<Language, Counts> langCounts = countsCache.getPathCounts().get(path);
            AttributesImpl fileAttrs = new AttributesImpl();
            this.addAttribute(fileAttrs, "pathname", this.preparePathname(path).toString());
            if (unrecognized.contains(path)) {
                this.addAttribute(fileAttrs, "unrecognized", "true");
            }
            this.addAttribute(fileAttrs, "numLanguages", langCounts.size());
            this.addCountAttributes(fileAttrs, pathTotals.getOrDefault(path, Counts.ZERO));
            xmlWriter.startElement(NAMESPACE, "file", (Attributes)fileAttrs);
            ArrayList<Language> languages = new ArrayList<Language>(langCounts.keySet());
            languages.sort(Comparator.comparing(Language::getDisplayName));
            for (Language language : languages) {
                this.writeLanguageRef(xmlWriter, language, langCounts.get(language));
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
    }

    private void writeLanguage(XmlWriter xmlWriter, Language language, Counts counts) throws SAXException {
        AttributesImpl langAttrs = new AttributesImpl();
        this.addAttribute(langAttrs, "name", language.name());
        this.addAttribute(langAttrs, "displayName", language.getDisplayName());
        this.addAttribute(langAttrs, "description", language.getDescription());
        this.addAttribute(langAttrs, "website", language.getWebsite());
        this.addCountAttributes(langAttrs, counts);
        xmlWriter.startElement(NAMESPACE, "language", (Attributes)langAttrs);
        xmlWriter.endElement();
    }

    private void writeLanguageRef(XmlWriter xmlWriter, Language language, Counts counts) throws SAXException {
        AttributesImpl langAttrs = new AttributesImpl();
        this.addAttribute(langAttrs, "name", language.name());
        this.addCountAttributes(langAttrs, counts);
        xmlWriter.startElement(NAMESPACE, "language", (Attributes)langAttrs);
        xmlWriter.endElement();
    }

    private void addCountAttributes(AttributesImpl attrs, Counts counts) {
        this.addAttribute(attrs, "totalLines", counts.getTotalLines());
        this.addAttribute(attrs, "codeLines", counts.getCodeLines());
        this.addAttribute(attrs, "commentLines", counts.getCommentLines());
        this.addAttribute(attrs, "blankLines", counts.getBlankLines());
    }

    private void addAttribute(AttributesImpl attrs, String name, @Nullable String value) {
        if (value != null) {
            attrs.addAttribute("", "", name, "CDATA", value);
        }
    }

    private void addAttribute(AttributesImpl attrs, String name, int value) {
        this.addAttribute(attrs, name, Integer.toString(value, 10));
    }
}

