/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.gradle.plugins.locc.reports;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.cthing.gradle.plugins.locc.CountsCache;
import org.cthing.gradle.plugins.locc.reports.AbstractLoccReport;
import org.cthing.locc4j.Counts;
import org.cthing.locc4j.Language;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.TaskExecutionException;

public final class TextReport
extends AbstractLoccReport {
    @Inject
    public TextReport(Task task, DirectoryProperty reportsDir) {
        super(task, "text", "Report in text format", false);
        this.getOutputLocation().value(reportsDir.file("locc.txt"));
    }

    @Override
    public void generateReport(CountsCache countsCache) {
        Counts totalCounts = countsCache.getTotalCounts();
        Set<Language> languages = countsCache.getLanguages();
        File destination = (File)this.getOutputLocation().getAsFile().get();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(destination.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            writer.write("Line Count Report For ");
            this.writeln(writer, this.task.getProject().getName());
            this.writeln(writer, "-".repeat(80));
            this.writeln(writer, "Date: ", this.timestamp());
            this.writeln(writer, "Project version: ", this.task.getProject().getVersion().toString());
            this.writeln(writer, "Number of files: ", countsCache.getPathCounts().size());
            this.writeln(writer, "Number unrecognized files: ", countsCache.getUnrecognized().size());
            this.writeln(writer, "Number of languages: ", languages.size());
            this.writeln(writer, "Total lines: ", totalCounts.getTotalLines());
            this.writeln(writer, "Code lines: ", totalCounts.getCodeLines());
            this.writeln(writer, "Comment lines: ", totalCounts.getCommentLines());
            this.writeln(writer, "Blank lines: ", totalCounts.getBlankLines());
            this.writeLanguages(writer, countsCache);
            this.writeFiles(writer, countsCache);
        }
        catch (IOException ex) {
            throw new TaskExecutionException(this.task, (Throwable)ex);
        }
    }

    private void writeLanguages(BufferedWriter writer, CountsCache countsCache) throws IOException {
        writer.newLine();
        this.writeln(writer, "Languages");
        this.writeln(writer, "-".repeat(9));
        Map<Language, Counts> langCounts = countsCache.getLanguageCounts();
        ArrayList<Language> languages = new ArrayList<Language>(langCounts.keySet());
        languages.sort(Comparator.comparing(Language::getDisplayName));
        for (Language language : languages) {
            String description = language.getDescription();
            if (description == null) {
                this.writeln(writer, String.format("%s", language.getDisplayName()));
            } else {
                this.writeln(writer, String.format("%s: %s", language.getDisplayName(), description));
            }
            this.writeCounts(writer, langCounts.get(language));
            writer.newLine();
        }
    }

    private void writeFiles(BufferedWriter writer, CountsCache countsCache) throws IOException {
        this.writeln(writer, "Files");
        this.writeln(writer, "-".repeat(5));
        Map<Path, Counts> pathTotals = countsCache.getFileCounts();
        Set<Path> unrecognized = countsCache.getUnrecognized();
        ArrayList<Path> paths = new ArrayList<Path>(countsCache.getPathCounts().keySet());
        paths.sort(Path::compareTo);
        boolean first = true;
        for (Path path : paths) {
            if (!first) {
                writer.newLine();
            }
            first = false;
            Map<Language, Counts> langCounts = countsCache.getPathCounts().get(path);
            if (unrecognized.contains(path)) {
                this.writeln(writer, this.preparePathname(path) + " (unrecognized)");
                continue;
            }
            this.writeln(writer, this.preparePathname(path).toString());
            this.writeCounts(writer, pathTotals.getOrDefault(path, Counts.ZERO));
            ArrayList<Language> languages = new ArrayList<Language>(langCounts.keySet());
            languages.sort(Comparator.comparing(Language::getDisplayName));
            writer.write("    Languages: ");
            this.writeln(writer, languages.stream().map(Language::getDisplayName).collect(Collectors.joining(", ")));
        }
    }

    private void writeCounts(BufferedWriter writer, Counts counts) throws IOException {
        this.writeln(writer, String.format("    Lines: %d total, %d code, %d comment, %d blank", counts.getTotalLines(), counts.getCodeLines(), counts.getCommentLines(), counts.getBlankLines()));
    }

    private void writeln(BufferedWriter writer, String str1, String str2) throws IOException {
        writer.write(str1);
        writer.write(str2);
        writer.newLine();
    }

    private void writeln(BufferedWriter writer, String str, int val) throws IOException {
        writer.write(str);
        writer.write(Integer.toString(val, 10));
        writer.newLine();
    }

    private void writeln(BufferedWriter writer, String str) throws IOException {
        writer.write(str);
        writer.newLine();
    }
}

