/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.gradle.plugins.locc.reports;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.cthing.gradle.plugins.locc.CountsCache;
import org.cthing.gradle.plugins.locc.reports.AbstractLoccReport;
import org.cthing.jsonwriter.JsonWriter;
import org.cthing.locc4j.Counts;
import org.cthing.locc4j.Language;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.TaskExecutionException;

public final class JsonReport
extends AbstractLoccReport {
    private static final int FORMAT_VERSION = 1;

    @Inject
    public JsonReport(Task task, DirectoryProperty reportsDir) {
        super(task, "json", "Report in JSON format", false);
        this.getOutputLocation().value(reportsDir.file("locc.json"));
    }

    @Override
    public void generateReport(CountsCache countsCache) {
        Counts totalCounts = countsCache.getTotalCounts();
        Set<Language> languages = countsCache.getLanguages();
        File destination = (File)this.getOutputLocation().getAsFile().get();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(destination.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            JsonWriter jsonWriter = new JsonWriter((Writer)writer);
            jsonWriter.setPrettyPrint(true);
            jsonWriter.startObject();
            jsonWriter.member("formatVersion", 1).member("date", this.timestamp()).member("projectName", this.task.getProject().getName()).member("projectVersion", this.task.getProject().getVersion().toString()).member("numFiles", countsCache.getPathCounts().size()).member("numUnrecognized", countsCache.getUnrecognized().size()).member("numLanguages", languages.size());
            this.writeCounts(jsonWriter, totalCounts);
            this.writeLanguages(jsonWriter, countsCache);
            this.writeFiles(jsonWriter, countsCache);
            jsonWriter.endObject();
        }
        catch (IOException ex) {
            throw new TaskExecutionException(this.task, (Throwable)ex);
        }
    }

    private void writeLanguages(JsonWriter jsonWriter, CountsCache countsCache) throws IOException {
        jsonWriter.memberStartArray("languages");
        Map<Language, Counts> langCounts = countsCache.getLanguageCounts();
        ArrayList<Language> languages = new ArrayList<Language>(langCounts.keySet());
        languages.sort(Comparator.comparing(Language::getDisplayName));
        for (Language language : languages) {
            jsonWriter.startObject();
            jsonWriter.member("name", language.name()).member("displayName", language.getDisplayName()).member("description", language.getDescription()).member("website", language.getWebsite());
            this.writeCounts(jsonWriter, langCounts.get(language));
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
    }

    private void writeFiles(JsonWriter jsonWriter, CountsCache countsCache) throws IOException {
        jsonWriter.memberStartArray("files");
        Map<Path, Counts> pathTotals = countsCache.getFileCounts();
        Set<Path> unrecognized = countsCache.getUnrecognized();
        ArrayList<Path> paths = new ArrayList<Path>(countsCache.getPathCounts().keySet());
        paths.sort(Path::compareTo);
        for (Path path : paths) {
            jsonWriter.startObject();
            Map<Language, Counts> langCounts = countsCache.getPathCounts().get(path);
            jsonWriter.member("pathname", this.preparePathname(path).toString()).member("numLanguages", langCounts.size());
            if (unrecognized.contains(path)) {
                jsonWriter.member("unrecognized", true);
            }
            this.writeCounts(jsonWriter, pathTotals.getOrDefault(path, Counts.ZERO));
            jsonWriter.memberStartArray("languages");
            ArrayList<Language> languages = new ArrayList<Language>(langCounts.keySet());
            languages.sort(Comparator.comparing(Language::getDisplayName));
            for (Language language : languages) {
                jsonWriter.startObject();
                jsonWriter.member("name", language.name());
                this.writeCounts(jsonWriter, langCounts.get(language));
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
    }

    private void writeCounts(JsonWriter jsonWriter, Counts counts) throws IOException {
        jsonWriter.member("totalLines", counts.getTotalLines()).member("codeLines", counts.getCodeLines()).member("commentLines", counts.getCommentLines()).member("blankLines", counts.getBlankLines());
    }
}

