/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.gradle.plugins.locc;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.cthing.gradle.plugins.locc.reports.CsvReport;
import org.cthing.gradle.plugins.locc.reports.HtmlReport;
import org.cthing.gradle.plugins.locc.reports.JsonReport;
import org.cthing.gradle.plugins.locc.reports.LoccReport;
import org.cthing.gradle.plugins.locc.reports.TextReport;
import org.cthing.gradle.plugins.locc.reports.XmlReport;
import org.cthing.gradle.plugins.locc.reports.YamlReport;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.NamedDomainObjectCollectionSchema;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Namer;
import org.gradle.api.Rule;
import org.gradle.api.Task;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.ReportContainer;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.jspecify.annotations.Nullable;

public class LoccReports
extends GroovyObjectSupport
implements ReportContainer<LoccReport> {
    private final NamedDomainObjectSet<LoccReport> reports;
    private final NamedDomainObjectSet<LoccReport> enabled;

    public LoccReports(Task task, DirectoryProperty reportsDir) {
        this.reports = task.getProject().getObjects().namedDomainObjectSet(LoccReport.class);
        this.enabled = this.reports.matching(report -> (Boolean)report.getRequired().get());
        this.reports.add((Object)new XmlReport(task, reportsDir));
        this.reports.add((Object)new HtmlReport(task, reportsDir));
        this.reports.add((Object)new YamlReport(task, reportsDir));
        this.reports.add((Object)new JsonReport(task, reportsDir));
        this.reports.add((Object)new CsvReport(task, reportsDir));
        this.reports.add((Object)new TextReport(task, reportsDir));
    }

    @Internal
    public LoccReport getXml() {
        return this.getByName("xml");
    }

    @Internal
    public LoccReport getHtml() {
        return this.getByName("html");
    }

    @Internal
    public LoccReport getYaml() {
        return this.getByName("yaml");
    }

    @Internal
    public LoccReport getJson() {
        return this.getByName("json");
    }

    @Internal
    public LoccReport getCsv() {
        return this.getByName("csv");
    }

    @Internal
    public LoccReport getText() {
        return this.getByName("text");
    }

    public NamedDomainObjectSet<LoccReport> getEnabled() {
        return this.enabled;
    }

    public boolean add(LoccReport report) {
        throw new ReportContainer.ImmutableViolationException();
    }

    public boolean addAll(Collection<? extends LoccReport> reps) {
        throw new ReportContainer.ImmutableViolationException();
    }

    public void addLater(Provider<? extends LoccReport> provider) {
        throw new ReportContainer.ImmutableViolationException();
    }

    public void addAllLater(Provider<? extends Iterable<LoccReport>> provider) {
        throw new ReportContainer.ImmutableViolationException();
    }

    public boolean remove(Object report) {
        throw new ReportContainer.ImmutableViolationException();
    }

    public boolean removeAll(Collection<?> reps) {
        throw new ReportContainer.ImmutableViolationException();
    }

    public boolean retainAll(Collection<?> reps) {
        throw new ReportContainer.ImmutableViolationException();
    }

    public void clear() {
        throw new ReportContainer.ImmutableViolationException();
    }

    public boolean containsAll(Collection<?> reps) {
        return this.reports.containsAll(reps);
    }

    public Namer<LoccReport> getNamer() {
        return Report::getName;
    }

    public SortedMap<String, LoccReport> getAsMap() {
        return this.reports.getAsMap();
    }

    public SortedSet<String> getNames() {
        return this.reports.getNames();
    }

    public @Nullable LoccReport findByName(String name) {
        return (LoccReport)this.reports.findByName(name);
    }

    public LoccReport getByName(String name) throws UnknownDomainObjectException {
        return (LoccReport)this.reports.getByName(name);
    }

    public LoccReport getByName(String name, Closure configureClosure) throws UnknownDomainObjectException {
        return (LoccReport)this.reports.getByName(name, configureClosure);
    }

    public LoccReport getByName(String name, Action<? super LoccReport> configureAction) throws UnknownDomainObjectException {
        return (LoccReport)this.reports.getByName(name, configureAction);
    }

    public LoccReport getAt(String name) throws UnknownDomainObjectException {
        return (LoccReport)this.reports.getAt(name);
    }

    public Rule addRule(Rule rule) {
        return this.reports.addRule(rule);
    }

    public Rule addRule(String description, Closure ruleAction) {
        return this.reports.addRule(description, ruleAction);
    }

    public Rule addRule(String description, Action<String> ruleAction) {
        return this.reports.addRule(description, ruleAction);
    }

    public List<Rule> getRules() {
        return this.reports.getRules();
    }

    public int size() {
        return this.reports.size();
    }

    public boolean isEmpty() {
        return this.reports.isEmpty();
    }

    public boolean contains(Object report) {
        return this.reports.contains(report);
    }

    public Iterator<LoccReport> iterator() {
        return this.reports.iterator();
    }

    public Object[] toArray() {
        return this.reports.toArray();
    }

    public <T> T[] toArray(T[] arr) {
        return this.reports.toArray((Object[])((LoccReport[])arr));
    }

    public Map<String, LoccReport> getEnabledReports() {
        return this.enabled.getAsMap();
    }

    public <S extends LoccReport> NamedDomainObjectSet<S> withType(Class<S> type) {
        return this.reports.withType(type);
    }

    public <S extends LoccReport> DomainObjectCollection<S> withType(Class<S> type, Action<? super S> configureAction) {
        return this.reports.withType(type, configureAction);
    }

    public <S extends LoccReport> DomainObjectCollection<S> withType(Class<S> type, Closure configureClosure) {
        return this.reports.withType(type, configureClosure);
    }

    public NamedDomainObjectSet<LoccReport> matching(Spec<? super LoccReport> spec) {
        return this.reports.matching(spec);
    }

    public NamedDomainObjectSet<LoccReport> matching(Closure spec) {
        return this.reports.matching(spec);
    }

    public Action<? super LoccReport> whenObjectAdded(Action<? super LoccReport> action) {
        return this.reports.whenObjectAdded(action);
    }

    public void whenObjectAdded(Closure action) {
        this.reports.whenObjectAdded(action);
    }

    public Action<? super LoccReport> whenObjectRemoved(Action<? super LoccReport> action) {
        return this.reports.whenObjectRemoved(action);
    }

    public void whenObjectRemoved(Closure action) {
        this.reports.whenObjectRemoved(action);
    }

    public void all(Action<? super LoccReport> action) {
        this.reports.all(action);
    }

    public void all(Closure action) {
        this.reports.all(action);
    }

    public void configureEach(Action<? super LoccReport> action) {
        this.reports.configureEach(action);
    }

    public NamedDomainObjectProvider<LoccReport> named(String name) throws UnknownDomainObjectException {
        return this.reports.named(name);
    }

    public NamedDomainObjectProvider<LoccReport> named(String name, Action<? super LoccReport> configurationAction) throws UnknownDomainObjectException {
        return this.reports.named(name, configurationAction);
    }

    public <S extends LoccReport> NamedDomainObjectProvider<S> named(String name, Class<S> type) throws UnknownDomainObjectException {
        return this.reports.named(name, type);
    }

    public <S extends LoccReport> NamedDomainObjectProvider<S> named(String name, Class<S> type, Action<? super S> configurationAction) throws UnknownDomainObjectException {
        return this.reports.named(name, type, configurationAction);
    }

    public NamedDomainObjectSet<LoccReport> named(Spec<String> nameFilter) {
        return this.reports.named(nameFilter);
    }

    public NamedDomainObjectCollectionSchema getCollectionSchema() {
        return this.reports.getCollectionSchema();
    }

    public Set<LoccReport> findAll(Closure spec) {
        return this.reports.findAll(spec);
    }

    public ReportContainer<LoccReport> configure(Closure closure) {
        Closure cl = (Closure)closure.clone();
        cl.setResolveStrategy(1);
        cl.setDelegate((Object)this);
        cl.call((Object)this);
        return this;
    }
}

