/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.gradle.plugins.locc;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.cthing.gradle.plugins.locc.LoccExtension;
import org.cthing.gradle.plugins.locc.LoccTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.CppComponent;
import org.gradle.language.cpp.CppLibrary;
import org.gradle.language.swift.SwiftApplication;
import org.gradle.language.swift.SwiftComponent;
import org.gradle.language.swift.SwiftLibrary;
import org.gradle.nativeplatform.test.cpp.CppTestSuite;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestSuite;

public class LoccPlugin
implements Plugin<Project> {
    public static final String EXTENSION_NAME = "locc";
    public static final String TASK_NAME = "countCodeLines";

    public void apply(Project project) {
        project.getPluginManager().apply(ReportingBasePlugin.class);
        LoccExtension extension = (LoccExtension)project.getExtensions().create(EXTENSION_NAME, LoccExtension.class, new Object[]{project});
        project.getTasks().register(TASK_NAME, LoccTask.class, loccTask -> {
            Callable<Set> filesProvider = () -> {
                HashSet files = new HashSet();
                for (Project proj : project.getAllprojects()) {
                    SwiftComponent swiftComponent;
                    SourceSetContainer sourceSets = (SourceSetContainer)proj.getExtensions().findByType(SourceSetContainer.class);
                    if (sourceSets != null) {
                        for (SourceSet sourceSet : sourceSets) {
                            if ("test".equals(sourceSet.getName()) && !((Boolean)extension.getIncludeTestSources().get()).booleanValue()) continue;
                            files.addAll(sourceSet.getAllSource().getFiles());
                        }
                    }
                    List.of(CppApplication.class, CppLibrary.class).forEach(clazz -> {
                        CppComponent cppComponent = (CppComponent)proj.getExtensions().findByType(clazz);
                        if (cppComponent != null) {
                            files.addAll(cppComponent.getCppSource().getFiles());
                            files.addAll(cppComponent.getHeaderFiles().getFiles());
                        }
                    });
                    List.of(SwiftApplication.class, SwiftLibrary.class).forEach(clazz -> {
                        SwiftComponent swiftComponent = (SwiftComponent)proj.getExtensions().findByType(clazz);
                        if (swiftComponent != null) {
                            files.addAll(swiftComponent.getSwiftSource().getFiles());
                        }
                    });
                    if (!((Boolean)extension.getIncludeTestSources().get()).booleanValue()) continue;
                    CppComponent cppComponent = (CppComponent)proj.getExtensions().findByType(CppTestSuite.class);
                    if (cppComponent != null) {
                        files.addAll(cppComponent.getCppSource().getFiles());
                        files.addAll(cppComponent.getHeaderFiles().getFiles());
                    }
                    if ((swiftComponent = (SwiftComponent)proj.getExtensions().findByType(SwiftXCTestSuite.class)) == null) continue;
                    files.addAll(swiftComponent.getSwiftSource().getFiles());
                }
                return files;
            };
            loccTask.setSource(filesProvider);
        });
    }
}

