/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.gradle.plugins.locc;

import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.reporting.ReportingExtension;

public class LoccExtension {
    private final Property<Boolean> includeTestSources;
    private final Property<Boolean> countDocStrings;
    private final DirectoryProperty reportsDir;

    public LoccExtension(Project project) {
        ObjectFactory objects = project.getObjects();
        this.includeTestSources = objects.property(Boolean.class).convention((Object)Boolean.TRUE);
        this.countDocStrings = objects.property(Boolean.class).convention((Object)Boolean.TRUE);
        DirectoryProperty baseReportsDir = ((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).getBaseDirectory();
        this.reportsDir = objects.directoryProperty().convention(baseReportsDir.map(base -> base.dir("locc")));
    }

    public Property<Boolean> getIncludeTestSources() {
        return this.includeTestSources;
    }

    public Property<Boolean> getCountDocStrings() {
        return this.countDocStrings;
    }

    public DirectoryProperty getReportsDir() {
        return this.reportsDir;
    }
}

