/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.gradle.plugins.locc;

import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import org.cthing.locc4j.CountUtils;
import org.cthing.locc4j.Counts;
import org.cthing.locc4j.Language;
import org.jspecify.annotations.Nullable;

public class CountsCache {
    private final Map<Path, Map<Language, Counts>> pathCounts;
    private @Nullable Set<Language> languages;
    private @Nullable Counts totalCounts;
    private @Nullable Map<Language, Counts> languageCounts;
    private @Nullable Map<Path, Counts> fileCounts;
    private @Nullable Set<Path> unrecognized;

    CountsCache(Map<Path, Map<Language, Counts>> pathCounts) {
        this.pathCounts = pathCounts;
    }

    public Map<Path, Map<Language, Counts>> getPathCounts() {
        return this.pathCounts;
    }

    public Set<Language> getLanguages() {
        if (this.languages == null) {
            this.languages = CountUtils.languages(this.pathCounts);
        }
        return this.languages;
    }

    public Counts getTotalCounts() {
        if (this.totalCounts == null) {
            this.totalCounts = CountUtils.total(this.pathCounts);
        }
        return this.totalCounts;
    }

    public Map<Language, Counts> getLanguageCounts() {
        if (this.languageCounts == null) {
            this.languageCounts = CountUtils.byLanguage(this.pathCounts);
        }
        return this.languageCounts;
    }

    public Map<Path, Counts> getFileCounts() {
        if (this.fileCounts == null) {
            this.fileCounts = CountUtils.byFile(this.pathCounts);
        }
        return this.fileCounts;
    }

    public Set<Path> getUnrecognized() {
        if (this.unrecognized == null) {
            this.unrecognized = CountUtils.unrecognized(this.pathCounts);
        }
        return this.unrecognized;
    }
}

