/*
 * Copyright 2024 C Thing Software
 * SPDX-License-Identifier: Apache-2.0
 */

package org.cthing.gradle.plugins.locc.reports;

import org.cthing.gradle.plugins.locc.CountsCache;
import org.gradle.api.provider.Property;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.tasks.Input;


/**
 * Represents a line count report generated by the plugin.
 */
public interface LoccReport extends SingleFileReport {

    /**
     * Obtains the flag indicating whether to report file pathnames as relative to the root of the Gradle project.
     * The default is {@code true} to show pathnames relative to the project root.
     *
     * @return Flag indicating whether to report file pathnames as relative to the Gradle project root.
     */
    @Input
    Property<Boolean> getShowRelativePaths();

    /**
     * Writes the line count report in a specific file format.
     *
     * @param countsCache Cache of line count data to report
     */
    void generateReport(CountsCache countsCache);
}
