/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import java.io.File;
import javax.jcr.Repository;
import org.apache.jackrabbit.core.TransientRepository;
import org.crsh.jcr.JackrabbitPlugin;
import org.crsh.jcr.RepositoryProvider;

public class JackrabbitRepositoryProvider
extends RepositoryProvider {
    private Repository repository;

    public void bootstrap() throws Exception {
        new JackrabbitPlugin().init();
        File config = new File(Thread.currentThread().getContextClassLoader().getResource("conf/transient/").toURI());
        this.repository = new TransientRepository("repository-in-memory.xml", config.getPath());
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getLogin() throws Exception {
        File config = new File(Thread.currentThread().getContextClassLoader().getResource("conf/transient/").toURI());
        return "repo use org.apache.jackrabbit.repository.conf=repository-in-memory.xml;org.apache.jackrabbit.repository.home=" + config.getAbsolutePath();
    }

    public void logout() throws Exception {
        File config = new File(Thread.currentThread().getContextClassLoader().getResource("conf/transient/").toURI());
        if (config.exists()) {
            config.delete();
        }
    }
}

