/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.ordering;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.codehaus.mojo.versions.ordering.SegmentCounter;
import org.codehaus.mojo.versions.utils.ArtifactVersionService;

public enum DefaultSegmentCounter implements SegmentCounter
{
    INSTANCE;

    private static final Pattern SNAPSHOT_PATTERN;

    private static ArtifactVersion stripSnapshot(ArtifactVersion v) {
        String version = v.toString();
        Matcher matcher = SNAPSHOT_PATTERN.matcher(version);
        if (matcher.find()) {
            return ArtifactVersionService.getArtifactVersion(version.substring(0, matcher.start(1) - 1));
        }
        return v;
    }

    private int innerGetSegmentCount(ArtifactVersion v) {
        if (v.getBuildNumber() != 0) {
            return 4;
        }
        if ((v.getMajorVersion() != 0 || v.getMinorVersion() != 0 || v.getIncrementalVersion() != 0) && v.getQualifier() != null) {
            return 4;
        }
        String version = v.toString();
        if (version.indexOf(45) != -1) {
            return version.equals(v.getQualifier()) ? 1 : 4;
        }
        if (version.indexOf(46) != -1) {
            return version.equals(v.getQualifier()) ? 1 : 3;
        }
        if (StringUtils.isEmpty((CharSequence)version)) {
            return 3;
        }
        try {
            Integer.parseInt(version);
            return 3;
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    @Override
    public final int getSegmentCount(@Nullable ArtifactVersion v) {
        if (v == null) {
            return 0;
        }
        if (ArtifactUtils.isSnapshot((String)v.toString())) {
            return this.innerGetSegmentCount(DefaultSegmentCounter.stripSnapshot(v));
        }
        return this.innerGetSegmentCount(v);
    }

    static {
        SNAPSHOT_PATTERN = Pattern.compile("(-((\\d{8}\\.\\d{6})-(\\d+))|(SNAPSHOT))$");
    }
}

