/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsReport;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.reporting.ReportRendererFactory;
import org.codehaus.mojo.versions.reporting.model.DependencyUpdatesModel;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.MavenProjectUtils;
import org.codehaus.mojo.versions.utils.MiscUtils;
import org.codehaus.mojo.versions.xml.DependencyUpdatesXmlReportRenderer;
import org.codehaus.plexus.i18n.I18N;

public abstract class AbstractDependencyUpdatesReportMojo
extends AbstractVersionsReport<DependencyUpdatesModel> {
    private static final DependencyComparator DEPENDENCY_COMPARATOR = DependencyComparator.INSTANCE;
    @Parameter(property="processDependencyManagement", defaultValue="true")
    protected boolean processDependencyManagement;
    @Parameter(property="processDependencyManagementTransitive", defaultValue="true")
    protected boolean processDependencyManagementTransitive;
    @Parameter(property="dependencyUpdatesReportFormats", defaultValue="html")
    protected String[] formats = new String[]{"html"};
    @Parameter(property="onlyProjectDependencies", defaultValue="false")
    protected boolean onlyProjectDependencies;
    @Parameter(property="onlyUpgradable", defaultValue="false")
    protected boolean onlyUpgradable;

    public AbstractDependencyUpdatesReportMojo(I18N i18n, RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, ReportRendererFactory rendererFactory) {
        super(i18n, repositorySystem, aetherRepositorySystem, wagonMap, rendererFactory);
    }

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return true;
    }

    @Override
    protected void doGenerateReport(Locale locale, Sink sink) throws MavenReportException {
        Set<Dependency> dependencyManagement;
        Set<Dependency> dependencies = this.getDependencies();
        if (this.processDependencyManagement) {
            dependencyManagement = this.getDependencyManagement(dependencies);
            this.handleOnlyProjectDependencies(dependencyManagement, dependencies);
        } else {
            dependencyManagement = Collections.emptySet();
        }
        try {
            Map dependencyManagementUpdates;
            Map dependencyUpdates = this.getHelper().lookupDependenciesUpdates(dependencies, false, this.allowSnapshots);
            Map map = dependencyManagementUpdates = this.processDependencyManagement ? this.getHelper().lookupDependenciesUpdates(dependencyManagement, false, this.allowSnapshots) : Collections.emptyMap();
            if (this.onlyUpgradable) {
                dependencyUpdates = MiscUtils.filter((Map)dependencyUpdates, e -> !e.isEmpty(this.allowSnapshots));
                dependencyManagementUpdates = MiscUtils.filter((Map)dependencyManagementUpdates, e -> !e.isEmpty(this.allowSnapshots));
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Dependency versions:");
                dependencyUpdates.forEach((key, value) -> this.getLog().debug((CharSequence)(key.toString() + ": " + Arrays.stream(value.getVersions(true)).map(Object::toString).collect(Collectors.joining(", ")))));
                this.getLog().debug((CharSequence)"Dependency management versions:");
                dependencyManagementUpdates.forEach((key, value) -> this.getLog().debug((CharSequence)(key.toString() + ": " + Arrays.stream(value.getVersions(true)).map(Object::toString).collect(Collectors.joining(", ")))));
            }
            DependencyUpdatesModel model = new DependencyUpdatesModel(dependencyUpdates, dependencyManagementUpdates);
            this.renderReport(locale, sink, model);
        }
        catch (VersionRetrievalException e2) {
            throw new RuntimeException(e2);
        }
    }

    protected void handleDependencyManagementTransitive(MavenProject project, Set<Dependency> dependencyManagementCollector) throws MavenReportException {
        if (this.processDependencyManagementTransitive) {
            if (this.hasDependencyManagement(project)) {
                for (Dependency dep : project.getDependencyManagement().getDependencies()) {
                    this.getLog().debug((CharSequence)("Dpmg: " + dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getVersion() + ":" + dep.getType() + ":" + dep.getScope()));
                }
                dependencyManagementCollector.addAll(project.getDependencyManagement().getDependencies());
            }
        } else if (project.getOriginalModel().getDependencyManagement() != null && project.getOriginalModel().getDependencyManagement().getDependencies() != null) {
            for (Dependency dep : project.getOriginalModel().getDependencyManagement().getDependencies()) {
                dep = MavenProjectUtils.interpolateVersion((Dependency)dep, (MavenProject)project);
                this.getLog().debug((CharSequence)("Original Dpmg: " + dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getVersion() + ":" + dep.getType() + ":" + dep.getScope()));
            }
            dependencyManagementCollector.addAll(project.getOriginalModel().getDependencyManagement().getDependencies());
        }
    }

    private void handleOnlyProjectDependencies(Set<Dependency> dependencyManagement, Set<Dependency> dependencies) {
        if (!this.onlyProjectDependencies) {
            dependencies.removeIf(dep -> dependencyManagement.stream().anyMatch(dmDep -> this.match((Dependency)dep, (Dependency)dmDep)));
        } else {
            dependencyManagement.removeIf(dep -> dependencies.stream().noneMatch(dmDep -> this.match((Dependency)dep, (Dependency)dmDep)));
        }
    }

    private Set<Dependency> getDependencies() {
        TreeSet<Dependency> dependenciesCollector = new TreeSet<Dependency>((Comparator<Dependency>)DEPENDENCY_COMPARATOR);
        this.populateDependencies(dependenciesCollector);
        return dependenciesCollector;
    }

    protected abstract void populateDependencies(Set<Dependency> var1);

    private Set<Dependency> getDependencyManagement(Set<Dependency> dependencies) throws MavenReportException {
        TreeSet<Dependency> dependencyManagementCollector = new TreeSet<Dependency>((Comparator<Dependency>)DEPENDENCY_COMPARATOR);
        this.populateDependencyManagement(dependencyManagementCollector, dependencies);
        return dependencyManagementCollector;
    }

    protected abstract void populateDependencyManagement(Set<Dependency> var1, Set<Dependency> var2) throws MavenReportException;

    private void renderReport(Locale locale, Sink sink, DependencyUpdatesModel model) throws MavenReportException {
        for (String format : this.formats) {
            if ("html".equals(format)) {
                this.rendererFactory.createReportRenderer(this.getOutputName(), sink, locale, model, this.allowSnapshots).render();
                continue;
            }
            if (!"xml".equals(format)) continue;
            Path outputDir = Paths.get(this.getProject().getBuild().getDirectory(), new String[0]);
            if (!Files.exists(outputDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(outputDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new MavenReportException("Could not create the output directory");
                }
            }
            Path outputFile = outputDir.resolve(this.getOutputName() + ".xml");
            new DependencyUpdatesXmlReportRenderer(model, outputFile, this.allowSnapshots).render();
        }
    }

    private boolean match(Dependency dep, Dependency dmDep) {
        return !(!dmDep.getGroupId().equals(dep.getGroupId()) || !dmDep.getArtifactId().equals(dep.getArtifactId()) || dmDep.getScope() != null && !dmDep.getScope().equals(dep.getScope()) || dmDep.getClassifier() != null && !dmDep.getClassifier().equals(dep.getClassifier()) || dep.getVersion() != null && dmDep.getVersion() != null && !dmDep.getVersion().equals(dep.getVersion()));
    }

    protected boolean hasDependencyManagement(MavenProject project) {
        if (project == null) {
            return false;
        }
        return project.getDependencyManagement() != null && project.getDependencyManagement().getDependencies() != null;
    }

    public String getOutputName() {
        return "dependency-updates-report";
    }
}

