/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.properties.managers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.mojo.properties.managers.PropertiesManager;
import org.yaml.snakeyaml.Yaml;

@Named
@Singleton
public class YmlPropertiesManager
implements PropertiesManager {
    private static final String SUPPORTED_EXTENSION_YML = "yml";
    private static final String SUPPORTED_EXTENSION_YAML = "yaml";

    @Override
    public boolean isExtensionSupport(String extension) {
        return SUPPORTED_EXTENSION_YML.equals(extension) || SUPPORTED_EXTENSION_YAML.equals(extension);
    }

    @Override
    public Properties load(InputStream in) throws IOException {
        Properties properties = new Properties();
        Map<String, Object> map = this.flattenYamlToMap("", (Map)new Yaml().load(in));
        properties.putAll(map);
        return properties;
    }

    public Map<String, Object> flattenYamlToMap(String parentKey, Map<String, Object> yamlMap) {
        if (parentKey != null && !parentKey.trim().isEmpty()) {
            parentKey = parentKey.trim() + ".";
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : yamlMap.entrySet()) {
            String key = String.format("%s%s", parentKey, entry.getKey().trim());
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map<String, Object> stringObjectMap = this.flattenYamlToMap(key, (Map)value);
                result.putAll(stringObjectMap);
                continue;
            }
            if (value instanceof Collection) {
                Object[] values = ((Collection)value).toArray();
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] instanceof Map) {
                        result.putAll(this.flattenYamlToMap(String.format("%s%s[%d]", parentKey, entry.getKey(), i), (Map)values[i]));
                        continue;
                    }
                    result.put(String.format("%s%s[%d]", parentKey, entry.getKey(), i), String.valueOf(values[i]));
                }
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    @Override
    public void save(Properties properties, OutputStream out, String comments) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(out, StandardCharsets.ISO_8859_1);
        try (PrintWriter pw = new PrintWriter(outputStreamWriter);
             StringWriter sw = new StringWriter();){
            properties.store(sw, comments);
            comments = '#' + comments;
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader r = new BufferedReader(new StringReader(sw.toString()));){
                String line;
                while ((line = r.readLine()) != null) {
                    if (line.startsWith("#") && !line.equals(comments)) continue;
                    lines.add(line);
                }
            }
            Collections.sort(lines);
            for (String l : lines) {
                pw.println(l);
            }
        }
    }

    public String toString() {
        return String.format("%s [extension=%s]", this.getClass().getSimpleName(), SUPPORTED_EXTENSION_YML);
    }
}

