/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.header.transformer;

import org.codehaus.mojo.license.header.transformer.AbstractFileHeaderTransformer;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=FileHeaderTransformer.class, hint="properties")
public class PropertiesFileHeaderTransformer
extends AbstractFileHeaderTransformer {
    public PropertiesFileHeaderTransformer() {
        super("properties", "header transformer with properties file comment style", "###", "###", "# ");
    }

    @Override
    public String[] getDefaultAcceptedExtensions() {
        return new String[]{"properties", "sh", "py", "rb", "pl", "pm"};
    }

    @Override
    public String addHeader(String header, String content) {
        String result;
        int endProlog;
        String prolog = null;
        int startProlog = content.indexOf("#!");
        if (startProlog > -1 && (endProlog = content.indexOf(10, startProlog)) > -1) {
            prolog = content.substring(0, endProlog + 1);
        }
        if (prolog == null) {
            result = super.addHeader(header, content);
        } else {
            content = content.substring(prolog.length());
            result = super.addHeader(prolog + this.getLineSeparator() + header, content);
        }
        return result;
    }
}

