/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="remove-project-artifact", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class RemoveLocalArtifactMojo
extends AbstractMojo {
    @Parameter(defaultValue="true", property="buildhelper.removeAll")
    private boolean removeAll;
    @Parameter(defaultValue="true", property="buildhelper.failOnError")
    private boolean failOnError;
    @Component
    private MavenProject project;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    private ArtifactRepository localRepository;

    public void execute() throws MojoFailureException {
        File localArtifactFile = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(this.project.getArtifact()));
        File localArtifactDirectory = localArtifactFile.getParentFile();
        if (this.removeAll) {
            localArtifactDirectory = localArtifactDirectory.getParentFile();
        }
        try {
            FileUtils.deleteDirectory((File)localArtifactDirectory);
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)(localArtifactDirectory.getAbsolutePath() + " removed."));
            }
        }
        catch (IOException e) {
            String failureMessage = "Cannot delete " + localArtifactDirectory;
            if (this.failOnError) {
                throw new MojoFailureException(failureMessage);
            }
            this.getLog().warn((CharSequence)failureMessage);
        }
    }
}

