/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.buildhelper.AbstractDefinePropertyMojo;

@Mojo(name="cpu-count", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class CpuCountMojo
extends AbstractDefinePropertyMojo {
    @Parameter(defaultValue="cpu.count")
    private String cpuCount;
    @Parameter(defaultValue="1.0")
    private float factor;

    public void execute() throws MojoExecutionException {
        float count = (float)Runtime.getRuntime().availableProcessors() * this.factor;
        if (count < 1.0f) {
            count = 1.0f;
        }
        this.defineProperty(this.cpuCount, Integer.toString((int)count));
        this.getLog().info((CharSequence)("CPU count: " + this.getProject().getProperties().getProperty(this.cpuCount)));
    }
}

