/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.enunciate.ConfigMojo;
import org.codehaus.enunciate.main.Enunciate;

public class FailIfModuleDisabledMojo
extends AbstractMojo {
    private boolean skip = false;
    private String moduleName = null;
    private String message = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            if (this.moduleName == null) {
                throw new MojoExecutionException("A module name must be specified in order to check whether it's disabled.");
            }
            Enunciate enunciate = (Enunciate)this.getPluginContext().get(ConfigMojo.ENUNCIATE_PROPERTY);
            if (enunciate == null) {
                throw new MojoExecutionException("Enunciate mechanism not initialized yet.");
            }
            if (!enunciate.isModuleEnabled(this.moduleName)) {
                String message = "Enunciate module '" + this.moduleName + "' is disabled. See the console output for details.";
                if (this.message != null) {
                    message = this.message;
                }
                throw new MojoExecutionException(message);
            }
        }
    }
}

