/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.codehaus.enunciate.Artifact;
import org.codehaus.enunciate.EnunciateException;
import org.codehaus.enunciate.config.EnunciateConfiguration;
import org.codehaus.enunciate.main.Enunciate;
import org.codehaus.enunciate.modules.DeploymentModule;
import org.codehaus.enunciate.modules.FlexHomeAwareModule;
import org.codehaus.enunciate.modules.GWTHomeAwareModule;
import org.codehaus.enunciate.modules.OutputDirectoryAware;
import org.codehaus.enunciate.modules.ProjectExtensionModule;
import org.codehaus.enunciate.modules.ProjectTitleAware;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigMojo
extends AbstractMojo {
    public static final String ENUNCIATE_PROPERTY = "urn:" + ConfigMojo.class.getName() + "#enunciate";
    public static final String ENUNCIATE_STEPPER_PROPERTY = "urn:" + ConfigMojo.class.getName() + "#stepper";
    private Collection<org.apache.maven.artifact.Artifact> pluginDepdendencies;
    private Collection<org.apache.maven.artifact.Artifact> projectDependencies;
    private Artifact[] artifacts;
    private File configFile = null;
    private File generateDir = null;
    private File compileDir = null;
    private File buildDir = null;
    private File packageDir = null;
    private File scratchDir = null;
    private File outputDir = null;
    private boolean addGWTSources = true;
    private boolean addActionscriptSources = true;
    private boolean addXFireClientSourcesToTestClasspath = false;
    private boolean addJAXWSClientSourcesToTestClasspath = false;
    private String[] excludeProjectExtensions;
    private String gwtHome = null;
    private String flexHome = null;
    private boolean compileDebug = true;
    private Map<String, String> exports = new HashMap<String, String>();
    private String[] includes;
    private String[] excludes;
    private String warArtifactId = "spring.war.file";
    private String warArtifactName;
    private String warArtifactClassifier = null;
    protected MavenProject project;
    private MavenProjectHelper projectHelper;
    private MavenSession session;
    private MavenFileFilter configFilter;
    private static final TreeSet<String> ENUNCIATE_ADDED = new TreeSet();

    public void execute() throws MojoExecutionException {
        HashSet<File> sourceDirs = new HashSet<File>();
        List sourcePaths = this.project.getCompileSourceRoots();
        for (String sourcePath : sourcePaths) {
            File sourceDir = new File(sourcePath);
            if (!this.isEnunciateAdded(sourceDir)) {
                sourceDirs.add(sourceDir);
                continue;
            }
            this.getLog().info((CharSequence)(sourceDir + " appears to be added to the source roots by Enunciate.  Excluding from original source roots...."));
        }
        MavenSpecificEnunciate enunciate = this.loadMavenSpecificEnunciate(sourceDirs);
        EnunciateConfiguration config = this.createEnunciateConfiguration();
        config.setLabel(this.project.getArtifactId());
        if (this.configFile != null) {
            try {
                this.loadConfig(config, this.configFile);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Problem with enunciate config file " + this.configFile, e);
            }
            enunciate.setConfigFile(this.configFile);
        } else {
            File defaultConfig = new File(this.project.getBasedir(), "enunciate.xml");
            if (defaultConfig.exists()) {
                this.getLog().info((CharSequence)(defaultConfig.getAbsolutePath() + " exists, so it will be used."));
                try {
                    this.loadConfig(config, defaultConfig);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Problem with enunciate config file " + defaultConfig, e);
                }
                enunciate.setConfigFile(defaultConfig);
            }
        }
        if (this.includes != null) {
            for (String include : this.includes) {
                config.addApiIncludePattern(include);
            }
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                config.addApiExcludePattern(exclude);
            }
        }
        enunciate.setConfig(config);
        HashSet<org.apache.maven.artifact.Artifact> classpathEntries = new HashSet<org.apache.maven.artifact.Artifact>();
        classpathEntries.addAll(this.projectDependencies);
        Iterator it = classpathEntries.iterator();
        while (it.hasNext()) {
            org.apache.maven.artifact.Artifact artifact = (org.apache.maven.artifact.Artifact)it.next();
            String artifactScope = artifact.getScope();
            if (!"test".equals(artifactScope)) continue;
            it.remove();
        }
        StringBuffer classpath = new StringBuffer();
        Iterator classpathIt = classpathEntries.iterator();
        while (classpathIt.hasNext()) {
            classpath.append(((org.apache.maven.artifact.Artifact)classpathIt.next()).getFile().getAbsolutePath());
            if (!classpathIt.hasNext()) continue;
            classpath.append(File.pathSeparatorChar);
        }
        enunciate.setRuntimeClasspath(classpath.toString());
        classpathEntries.clear();
        classpathEntries.addAll(this.pluginDepdendencies);
        classpath = new StringBuffer();
        classpathIt = classpathEntries.iterator();
        while (classpathIt.hasNext()) {
            classpath.append(((org.apache.maven.artifact.Artifact)classpathIt.next()).getFile().getAbsolutePath());
            if (!classpathIt.hasNext()) continue;
            classpath.append(File.pathSeparatorChar);
        }
        enunciate.setBuildClasspath(classpath.toString());
        if (this.generateDir != null) {
            enunciate.setGenerateDir(this.generateDir);
        }
        if (this.compileDir != null) {
            enunciate.setCompileDir(this.compileDir);
        }
        if (this.buildDir != null) {
            enunciate.setBuildDir(this.buildDir);
        }
        if (this.packageDir != null) {
            enunciate.setPackageDir(this.packageDir);
        }
        if (this.scratchDir != null) {
            enunciate.setScratchDir(this.scratchDir);
        }
        if (this.exports != null) {
            for (String exportId : this.exports.keySet()) {
                String filename = this.exports.get(exportId);
                if (filename == null || "".equals(filename)) {
                    throw new MojoExecutionException("Invalid (empty or null) filename for export " + exportId + ".");
                }
                File exportFile = new File(filename);
                if (!exportFile.isAbsolute()) {
                    exportFile = new File(this.outputDir, filename);
                }
                enunciate.addExport(exportId, exportFile);
            }
        }
        enunciate.setCompileDebugInfo(this.compileDebug);
        try {
            enunciate.loadMavenConfiguration();
            Enunciate.Stepper stepper = enunciate.getStepper();
            this.getPluginContext().put(ENUNCIATE_STEPPER_PROPERTY, stepper);
            this.getPluginContext().put(ENUNCIATE_PROPERTY, enunciate);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error initializing Enunciate mechanism.", e);
        }
    }

    protected void loadConfig(EnunciateConfiguration config, File configFile) throws IOException, SAXException, MavenFilteringException {
        if (this.configFilter == null) {
            this.getLog().debug((CharSequence)"No maven file filter was provided, so no filtering of the config file will be done.");
            config.load(configFile);
        } else {
            this.scratchDir.mkdirs();
            File filteredConfig = File.createTempFile("enunciateConfig", ".xml", this.scratchDir);
            this.getLog().debug((CharSequence)("Filtering " + configFile + " to " + filteredConfig + "..."));
            this.configFilter.copyFile(configFile, filteredConfig, true, this.project, null, true, "utf-8", this.session);
            config.load(filteredConfig);
        }
    }

    protected boolean isEnunciateAdded(File sourceDir) {
        return ENUNCIATE_ADDED.contains(sourceDir.getAbsolutePath());
    }

    protected void addSourceDirToProject(File dir) {
        String sourceDir = dir.getAbsolutePath();
        ENUNCIATE_ADDED.add(sourceDir);
        if (!this.project.getCompileSourceRoots().contains(sourceDir)) {
            this.getLog().debug((CharSequence)("Adding '" + sourceDir + "' to the compile source roots."));
            this.project.addCompileSourceRoot(sourceDir);
        }
    }

    protected EnunciateConfiguration createEnunciateConfiguration() {
        return new EnunciateConfiguration();
    }

    protected MavenSpecificEnunciate loadMavenSpecificEnunciate(Set<File> sourceDirs) {
        return new MavenSpecificEnunciate(sourceDirs);
    }

    protected Set<String> getExcludedProjectExtensions() {
        TreeSet<String> excluded = new TreeSet<String>();
        if (this.excludeProjectExtensions != null) {
            excluded.addAll(Arrays.asList(this.excludeProjectExtensions));
        }
        if (!this.addActionscriptSources) {
            excluded.add("amf");
        }
        if (!this.addGWTSources) {
            excluded.add("gwt");
        }
        if (!this.addJAXWSClientSourcesToTestClasspath) {
            excluded.add("jaxws-client");
        }
        if (!this.addXFireClientSourcesToTestClasspath) {
            excluded.add("xfire-client");
        }
        return excluded;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MavenSpecificEnunciate
    extends Enunciate {
        public MavenSpecificEnunciate(Collection<File> rootDirs) {
            ArrayList sources = new ArrayList();
            for (File rootDir : rootDirs) {
                sources.addAll(this.getJavaFiles(rootDir));
            }
            this.setSourceFiles(sources.toArray(new String[sources.size()]));
        }

        public void loadMavenConfiguration() throws IOException {
            for (DeploymentModule module : this.getConfig().getAllModules()) {
                if (module.isDisabled()) continue;
                if (ConfigMojo.this.gwtHome != null && module instanceof GWTHomeAwareModule) {
                    ((GWTHomeAwareModule)module).setGwtHome(ConfigMojo.this.gwtHome);
                    continue;
                }
                if (ConfigMojo.this.flexHome == null || !(module instanceof FlexHomeAwareModule)) continue;
                ((FlexHomeAwareModule)module).setFlexHome(ConfigMojo.this.flexHome);
            }
        }

        protected void initModules(Collection<DeploymentModule> modules) throws EnunciateException, IOException {
            super.initModules(modules);
            if (ConfigMojo.this.compileDir == null) {
                this.setCompileDir(this.createTempDir());
            }
            for (DeploymentModule module : modules) {
                if (module.isDisabled()) continue;
                if (module instanceof OutputDirectoryAware) {
                    String outputDir = ConfigMojo.this.project.getBuild().getOutputDirectory();
                    this.debug("Setting the output directory for module %s to %s...", module.getName(), outputDir);
                    ((OutputDirectoryAware)module).setOutputDirectory(new File(outputDir));
                }
                if (ConfigMojo.this.project.getName() == null || "".equals(ConfigMojo.this.project.getName().trim()) || !(module instanceof ProjectTitleAware)) continue;
                ((ProjectTitleAware)module).setTitleConditionally(ConfigMojo.this.project.getName());
            }
        }

        protected void doGenerate() throws IOException, EnunciateException {
            super.doGenerate();
            for (DeploymentModule module : this.getConfig().getAllModules()) {
                if (module.isDisabled() || !(module instanceof ProjectExtensionModule) || ConfigMojo.this.getExcludedProjectExtensions().contains(module.getName())) continue;
                ProjectExtensionModule extensions = (ProjectExtensionModule)module;
                for (File projectSource : extensions.getProjectSources()) {
                    ConfigMojo.this.addSourceDirToProject(projectSource);
                }
                for (File testSource : extensions.getProjectTestSources()) {
                    ConfigMojo.this.project.addTestCompileSourceRoot(testSource.getAbsolutePath());
                }
                for (File resourceDir : extensions.getProjectResourceDirectories()) {
                    Resource restResource = new Resource();
                    restResource.setDirectory(resourceDir.getAbsolutePath());
                    ConfigMojo.this.project.addResource(restResource);
                }
                for (File resourceDir : extensions.getProjectTestResourceDirectories()) {
                    Resource resource = new Resource();
                    resource.setDirectory(resourceDir.getAbsolutePath());
                    ConfigMojo.this.project.addTestResource(resource);
                }
            }
        }

        public void info(String message, Object ... formatArgs) {
            ConfigMojo.this.getLog().info((CharSequence)String.format(message, formatArgs));
        }

        public void debug(String message, Object ... formatArgs) {
            ConfigMojo.this.getLog().debug((CharSequence)String.format(message, formatArgs));
        }

        public void warn(String message, Object ... formatArgs) {
            ConfigMojo.this.getLog().warn((CharSequence)String.format(message, formatArgs));
        }

        public boolean isDebug() {
            return ConfigMojo.this.getLog().isDebugEnabled();
        }

        public boolean isVerbose() {
            return ConfigMojo.this.getLog().isInfoEnabled();
        }

        protected void doClose() throws EnunciateException, IOException {
            super.doClose();
            if (ConfigMojo.this.warArtifactId != null) {
                org.codehaus.enunciate.main.Artifact warArtifact = null;
                for (org.codehaus.enunciate.main.Artifact artifact : this.getArtifacts()) {
                    if (!ConfigMojo.this.warArtifactId.equals(artifact.getId())) continue;
                    warArtifact = artifact;
                    break;
                }
                if (warArtifact != null) {
                    String classifier = ConfigMojo.this.warArtifactClassifier;
                    if (classifier == null) {
                        classifier = "";
                    } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
                        classifier = "-" + classifier;
                    }
                    File warArtifactFile = new File(ConfigMojo.this.outputDir, ConfigMojo.this.warArtifactName + classifier + ".war");
                    warArtifact.exportTo(warArtifactFile, (Enunciate)this);
                    ConfigMojo.this.project.getArtifact().setFile(warArtifactFile);
                } else {
                    ConfigMojo.this.getLog().debug((CharSequence)("War artifact '" + ConfigMojo.this.warArtifactId + "' not found in the project..."));
                }
            }
            if (ConfigMojo.this.artifacts != null) {
                for (Artifact projectArtifact : ConfigMojo.this.artifacts) {
                    if (projectArtifact.getEnunciateArtifactId() == null) {
                        ConfigMojo.this.getLog().warn((CharSequence)"No enunciate export id specified.  Skipping project artifact...");
                        continue;
                    }
                    org.codehaus.enunciate.main.Artifact artifact = null;
                    for (org.codehaus.enunciate.main.Artifact enunciateArtifact : this.getArtifacts()) {
                        if (!projectArtifact.getEnunciateArtifactId().equals(enunciateArtifact.getId())) continue;
                        artifact = enunciateArtifact;
                        break;
                    }
                    if (artifact != null) {
                        File tempExportFile = this.createTempFile(ConfigMojo.this.project.getArtifactId() + "-" + projectArtifact.getClassifier(), projectArtifact.getArtifactType());
                        artifact.exportTo(tempExportFile, (Enunciate)this);
                        ConfigMojo.this.projectHelper.attachArtifact(ConfigMojo.this.project, projectArtifact.getArtifactType(), projectArtifact.getClassifier(), tempExportFile);
                        continue;
                    }
                    ConfigMojo.this.getLog().warn((CharSequence)("Enunciate artifact '" + projectArtifact.getEnunciateArtifactId() + "' not found in the project..."));
                }
            }
        }
    }
}

