/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.enunciate.ConfigMojo;
import org.codehaus.enunciate.EnunciateException;
import org.codehaus.enunciate.main.Enunciate;
import org.codehaus.enunciate.modules.DeploymentModule;
import org.codehaus.enunciate.modules.ProjectAssemblyModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssembleMojo
extends ConfigMojo {
    private String webappDirectory;
    private boolean forceWarPackaging = true;
    private String stepTo = null;
    private AssembleOnlyMavenSpecificEnunciate enunciate = null;

    @Override
    public void execute() throws MojoExecutionException {
        if (this.forceWarPackaging && !"war".equalsIgnoreCase(this.project.getPackaging())) {
            throw new MojoExecutionException("The 'assemble' goal requires 'war' packaging.");
        }
        super.execute();
        Enunciate.Stepper stepper = (Enunciate.Stepper)this.getPluginContext().get(ConfigMojo.ENUNCIATE_STEPPER_PROPERTY);
        if (stepper == null) {
            throw new MojoExecutionException("No stepper found in the project!");
        }
        Enunciate.Target target = Enunciate.Target.PACKAGE;
        if (this.stepTo != null) {
            target = Enunciate.Target.valueOf((String)this.stepTo.toUpperCase());
        }
        try {
            stepper.stepTo(target);
            stepper.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem assembling the enunciate app.", e);
        }
        for (File additionalRoot : this.enunciate.getAdditionalSourceRoots()) {
            this.addSourceDirToProject(additionalRoot);
        }
    }

    @Override
    protected ConfigMojo.MavenSpecificEnunciate loadMavenSpecificEnunciate(Set<File> sourceFiles) {
        this.enunciate = new AssembleOnlyMavenSpecificEnunciate(sourceFiles);
        return this.enunciate;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AssembleOnlyMavenSpecificEnunciate
    extends ConfigMojo.MavenSpecificEnunciate {
        public AssembleOnlyMavenSpecificEnunciate(Collection<File> rootDirs) {
            super(rootDirs);
        }

        @Override
        protected void initModules(Collection<DeploymentModule> modules) throws EnunciateException, IOException {
            super.initModules(modules);
            for (DeploymentModule module : modules) {
                if (!(module instanceof ProjectAssemblyModule)) continue;
                ProjectAssemblyModule assemblyModule = (ProjectAssemblyModule)module;
                assemblyModule.setDoCompile(false);
                assemblyModule.setDoLibCopy(false);
                assemblyModule.setDoPackage(false);
                assemblyModule.setBuildDir(new File(AssembleMojo.this.project.getBasedir(), AssembleMojo.this.webappDirectory));
            }
        }
    }
}

