/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.objc;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import net.sf.jelly.apt.freemarker.FreemarkerModel;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.contract.jaxb.Attribute;
import org.codehaus.enunciate.contract.jaxb.Element;
import org.codehaus.enunciate.contract.jaxb.ElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.LocalElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.RootElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxb.Value;
import org.codehaus.enunciate.contract.jaxb.types.MapXmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlClassType;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferencedNamespacesMethod
implements TemplateMethodModelEx {
    public Object exec(List list) throws TemplateModelException {
        EnunciateFreemarkerModel model;
        TypeDefinition typeDefinition;
        TypeDeclaration typeDecl;
        if (list.size() < 1) {
            throw new TemplateModelException("The referencedNamespaces method must have an element as a parameter.");
        }
        TemplateModel from = (TemplateModel)list.get(0);
        Object unwrapped = BeansWrapper.getDefaultInstance().unwrap(from);
        if (!(unwrapped instanceof ElementDeclaration)) {
            throw new TemplateModelException("The referencedNamespaces method must have an element as a parameter.");
        }
        ElementDeclaration elementDeclaration = (ElementDeclaration)unwrapped;
        HashSet<String> referencedNamespaces = new HashSet<String>();
        referencedNamespaces.add(elementDeclaration.getNamespace());
        if (elementDeclaration instanceof RootElementDeclaration) {
            TypeDefinition typeDef = ((RootElementDeclaration)elementDeclaration).getTypeDefinition();
            this.addReferencedNamespaces(typeDef, referencedNamespaces);
        } else if (elementDeclaration instanceof LocalElementDeclaration && (typeDecl = ((LocalElementDeclaration)elementDeclaration).getElementTypeDeclaration()) instanceof ClassDeclaration && (typeDefinition = (model = (EnunciateFreemarkerModel)FreemarkerModel.get()).findTypeDefinition((ClassDeclaration)typeDecl)) != null) {
            this.addReferencedNamespaces(typeDefinition, referencedNamespaces);
        }
        referencedNamespaces.remove(null);
        referencedNamespaces.remove("");
        referencedNamespaces.remove("http://www.w3.org/2001/XMLSchema");
        return referencedNamespaces;
    }

    private void addReferencedNamespaces(TypeDefinition typeDefinition, Set<String> referencedNamespaces) {
        for (Attribute attribute : typeDefinition.getAttributes()) {
            QName ref = attribute.getRef();
            if (ref != null) {
                referencedNamespaces.add(ref.getNamespaceURI());
                continue;
            }
            this.addReferencedNamespaces(attribute.getBaseType(), referencedNamespaces);
        }
        for (Element element : typeDefinition.getElements()) {
            for (Element choice : element.getChoices()) {
                QName ref = choice.getRef();
                if (ref != null) {
                    referencedNamespaces.add(ref.getNamespaceURI());
                    continue;
                }
                this.addReferencedNamespaces(choice.getBaseType(), referencedNamespaces);
            }
        }
        Value value = typeDefinition.getValue();
        if (value != null) {
            this.addReferencedNamespaces(value.getBaseType(), referencedNamespaces);
        }
        this.addReferencedNamespaces(typeDefinition.getBaseType(), referencedNamespaces);
    }

    private void addReferencedNamespaces(XmlType xmlType, Set<String> referencedNamespaces) {
        if (!xmlType.isAnonymous()) {
            referencedNamespaces.add(xmlType.getNamespace());
        } else if (xmlType instanceof MapXmlType) {
            referencedNamespaces.add(((MapXmlType)xmlType).getKeyType().getNamespace());
            referencedNamespaces.add(((MapXmlType)xmlType).getValueType().getNamespace());
        } else if (xmlType instanceof XmlClassType) {
            this.addReferencedNamespaces(((XmlClassType)xmlType).getTypeDefinition(), referencedNamespaces);
        }
    }
}

