/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.objc;

import com.sun.mirror.declaration.Declaration;
import org.codehaus.enunciate.contract.jaxb.Attribute;
import org.codehaus.enunciate.contract.jaxb.ComplexTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.Element;
import org.codehaus.enunciate.contract.validation.BaseValidator;
import org.codehaus.enunciate.contract.validation.ValidationResult;
import org.codehaus.enunciate.util.MapType;

public class ObjCValidator
extends BaseValidator {
    public ValidationResult validateComplexType(ComplexTypeDefinition complexType) {
        ValidationResult result = super.validateComplexType(complexType);
        for (Attribute attribute : complexType.getAttributes()) {
            if (attribute.isXmlList()) {
                result.addWarning((Declaration)attribute, "The Objective-C client code won't serialize xml lists as an array, instead passing the list as a string that will need to be parsed. This may cause confusion to Objective-C consumers.");
            }
            if (!attribute.isCollectionType() || !attribute.isBinaryData()) continue;
            result.addError((Declaration)attribute, "The Objective-C client code doesn't support a collection of items that are binary data. You'll have to define separate accessors for each item or disable the Objective-C module.");
        }
        if (complexType.getValue() != null) {
            if (complexType.getValue().isXmlList()) {
                result.addWarning((Declaration)complexType.getValue(), "The Objective-C client code won't serialize xml lists as an array, instead passing the list as a string that will need to be parsed. This may cause confusion to Objective-C consumers.");
            }
            if (complexType.getValue().isCollectionType() && complexType.getValue().isBinaryData()) {
                result.addError((Declaration)complexType.getValue(), "The Objective-C client code doesn't support a collection of items that are binary data. You'll have to define separate accessors for each item or disable the Objective-C module.");
            }
        }
        for (Element element : complexType.getElements()) {
            if (element.isXmlList()) {
                result.addWarning((Declaration)element, "The Objective-C client code won't serialize xml lists as an array, instead passing the list as a string that will need to be parsed. This may cause confusion to Objective-C consumers.");
            }
            if (!(element.getAccessorType() instanceof MapType) || element.isAdapted()) continue;
            result.addError((Declaration)element, "The Objective-C client doesn't have a built-in way of serializing a Map. So you're going to have to use @XmlJavaTypeAdapter to supply your own adapter for the Map, or disable the Objective-C module.");
        }
        return result;
    }
}

