/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.objc;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.type.ClassType;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.sf.jelly.apt.decorations.JavaDoc;
import net.sf.jelly.apt.freemarker.FreemarkerJavaDoc;
import org.apache.commons.digester.RuleSet;
import org.codehaus.enunciate.EnunciateException;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.config.SchemaInfo;
import org.codehaus.enunciate.contract.common.rest.RESTResource;
import org.codehaus.enunciate.contract.jaxb.ElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.LocalElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.RootElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.validation.Validator;
import org.codehaus.enunciate.main.Artifact;
import org.codehaus.enunciate.main.ArtifactType;
import org.codehaus.enunciate.main.ClientLibraryArtifact;
import org.codehaus.enunciate.main.FileArtifact;
import org.codehaus.enunciate.main.NamedFileArtifact;
import org.codehaus.enunciate.modules.FreemarkerDeploymentModule;
import org.codehaus.enunciate.modules.objc.ClientClassnameForMethod;
import org.codehaus.enunciate.modules.objc.FindRootElementMethod;
import org.codehaus.enunciate.modules.objc.FunctionIdentifierForMethod;
import org.codehaus.enunciate.modules.objc.NameForEnumConstantMethod;
import org.codehaus.enunciate.modules.objc.NameForTypeDefinitionMethod;
import org.codehaus.enunciate.modules.objc.ObjCValidator;
import org.codehaus.enunciate.modules.objc.PrefixMethod;
import org.codehaus.enunciate.modules.objc.ReferencedNamespacesMethod;
import org.codehaus.enunciate.modules.objc.config.ObjCRuleSet;
import org.codehaus.enunciate.modules.objc.config.PackageIdentifier;
import org.codehaus.enunciate.template.freemarker.AccessorOverridesAnotherMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjCDeploymentModule
extends FreemarkerDeploymentModule {
    private static final Pattern SCRUB_PATTERN = Pattern.compile("\\W");
    private boolean forceEnable = false;
    private String label = null;
    private String packageIdentifierPattern = null;
    private String typeDefinitionNamePattern = "%1$S%2$S%4$s";
    private String enumConstantNamePattern = "%1$S_%2$S_%3$S_%9$S";
    private final Map<String, String> packageIdentifiers = new HashMap<String, String>();

    public String getName() {
        return "obj-c";
    }

    public static String scrubIdentifier(String identifier) {
        return identifier == null ? null : SCRUB_PATTERN.matcher(identifier).replaceAll("_");
    }

    public void initModel(EnunciateFreemarkerModel model) {
        super.initModel(model);
        if (!this.isDisabled() && this.packageIdentifierPattern != null) {
            for (SchemaInfo schemaInfo : model.getNamespacesToSchemas().values()) {
                for (TypeDefinition typeDefinition : schemaInfo.getTypeDefinitions()) {
                    String pckg = typeDefinition.getPackage().getQualifiedName();
                    if (this.packageIdentifiers.containsKey(pckg)) continue;
                    try {
                        this.packageIdentifiers.put(pckg, String.format(this.packageIdentifierPattern, pckg.split("\\.", 9)));
                    }
                    catch (IllegalFormatException e) {
                        this.warn("Unable to format package %s with format pattern %s (%s)", new Object[]{pckg, this.packageIdentifierPattern, e.getMessage()});
                    }
                }
            }
        }
    }

    public void doFreemarkerGenerate() throws IOException, TemplateException, EnunciateException {
        String label;
        File genDir = this.getGenerateDir();
        String string = this.getLabel() == null ? (this.getEnunciate().getConfig() == null ? "enunciate" : this.getEnunciate().getConfig().getLabel()) : (label = this.getLabel());
        if (!this.enunciate.isUpToDateWithSources(genDir)) {
            EnunciateFreemarkerModel model = this.getModel();
            ArrayList<TypeDefinition> schemaTypes = new ArrayList<TypeDefinition>();
            ExtensionDepthComparator comparator = new ExtensionDepthComparator();
            for (SchemaInfo schemaInfo : model.getNamespacesToSchemas().values()) {
                for (TypeDefinition typeDefinition : schemaInfo.getTypeDefinitions()) {
                    int position = Collections.binarySearch(schemaTypes, typeDefinition, comparator);
                    if (position < 0) {
                        position = -position - 1;
                    }
                    schemaTypes.add(position, typeDefinition);
                }
            }
            model.put("schemaTypes", schemaTypes);
            NameForTypeDefinitionMethod nameForTypeDefinition = new NameForTypeDefinitionMethod(this.getTypeDefinitionNamePattern(), label, model.getNamespacesToPrefixes(), this.packageIdentifiers);
            model.put("nameForTypeDefinition", (Object)nameForTypeDefinition);
            model.put("nameForEnumConstant", (Object)new NameForEnumConstantMethod(this.getEnumConstantNamePattern(), label, model.getNamespacesToPrefixes(), this.packageIdentifiers));
            TreeMap<String, String> conversions = new TreeMap<String, String>();
            for (SchemaInfo schemaInfo : model.getNamespacesToSchemas().values()) {
                for (TypeDefinition typeDefinition : schemaInfo.getTypeDefinitions()) {
                    if (typeDefinition.isEnum()) {
                        conversions.put(typeDefinition.getQualifiedName(), "enum " + nameForTypeDefinition.calculateName(typeDefinition));
                        continue;
                    }
                    conversions.put(typeDefinition.getQualifiedName(), (String)nameForTypeDefinition.calculateName(typeDefinition));
                }
            }
            ClientClassnameForMethod classnameFor = new ClientClassnameForMethod(conversions);
            model.put("classnameFor", (Object)classnameFor);
            model.put("functionIdentifierFor", (Object)new FunctionIdentifierForMethod(nameForTypeDefinition));
            model.put("objcBaseName", (Object)label);
            model.put("findRootElement", (Object)new FindRootElementMethod());
            model.put("referencedNamespaces", (Object)new ReferencedNamespacesMethod());
            model.put("prefix", (Object)new PrefixMethod());
            model.put("accessorOverridesAnother", (Object)new AccessorOverridesAnotherMethod());
            this.debug("Generating the C data structures and (de)serialization functions...", new Object[0]);
            URL apiTemplate = this.getTemplateURL("api.fmt");
            this.processTemplate(apiTemplate, model);
        } else {
            this.info("Skipping C code generation because everything appears up-to-date.", new Object[0]);
        }
        ClientLibraryArtifact artifactBundle = new ClientLibraryArtifact(this.getName(), "objc.client.library", "Objective C Client Library");
        NamedFileArtifact sourceHeader = new NamedFileArtifact(this.getName(), "objc.client.h", new File(this.getGenerateDir(), label + ".h"));
        sourceHeader.setPublic(false);
        sourceHeader.setArtifactType(ArtifactType.sources);
        NamedFileArtifact sourceImpl = new NamedFileArtifact(this.getName(), "objc.client.m", new File(this.getGenerateDir(), label + ".m"));
        sourceImpl.setPublic(false);
        sourceImpl.setArtifactType(ArtifactType.sources);
        String description = this.readResource("library_description.fmt");
        artifactBundle.setDescription(description);
        artifactBundle.addArtifact((FileArtifact)sourceHeader);
        artifactBundle.addArtifact((FileArtifact)sourceImpl);
        this.getEnunciate().addArtifact((Artifact)artifactBundle);
    }

    protected String readResource(String resource) throws IOException, EnunciateException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        RESTResource exampleResource = this.getModelInternal().findExampleResource();
        String label = this.getLabel() == null ? (this.getEnunciate().getConfig() == null ? "enunciate" : this.getEnunciate().getConfig().getLabel()) : this.getLabel();
        model.put("label", label);
        NameForTypeDefinitionMethod nameForTypeDefinition = new NameForTypeDefinitionMethod(this.getTypeDefinitionNamePattern(), label, this.getModelInternal().getNamespacesToPrefixes(), this.packageIdentifiers);
        if (exampleResource != null) {
            TypeDefinition typeDefinition;
            ElementDeclaration el;
            if (exampleResource.getInputPayload() != null && exampleResource.getInputPayload().getXmlElement() != null) {
                el = exampleResource.getInputPayload().getXmlElement();
                typeDefinition = null;
                if (el instanceof RootElementDeclaration) {
                    typeDefinition = this.getModelInternal().findTypeDefinition((ClassDeclaration)((RootElementDeclaration)el));
                } else if (el instanceof LocalElementDeclaration && ((LocalElementDeclaration)el).getElementTypeDeclaration() instanceof ClassDeclaration) {
                    typeDefinition = this.getModelInternal().findTypeDefinition((ClassDeclaration)((LocalElementDeclaration)el).getElementTypeDeclaration());
                }
                if (typeDefinition != null) {
                    model.put("input_element_name", nameForTypeDefinition.calculateName(typeDefinition));
                }
            }
            if (exampleResource.getOutputPayload() != null && exampleResource.getOutputPayload().getXmlElement() != null) {
                el = exampleResource.getOutputPayload().getXmlElement();
                typeDefinition = null;
                if (el instanceof RootElementDeclaration) {
                    typeDefinition = this.getModelInternal().findTypeDefinition((ClassDeclaration)((RootElementDeclaration)el));
                } else if (el instanceof LocalElementDeclaration && ((LocalElementDeclaration)el).getElementTypeDeclaration() instanceof ClassDeclaration) {
                    typeDefinition = this.getModelInternal().findTypeDefinition((ClassDeclaration)((LocalElementDeclaration)el).getElementTypeDeclaration());
                }
                if (typeDefinition != null) {
                    model.put("output_element_name", nameForTypeDefinition.calculateName(typeDefinition));
                }
            }
            model.put("resource_url", exampleResource.getPath());
            model.put("resource_method", exampleResource.getSupportedOperations() == null || exampleResource.getSupportedOperations().isEmpty() ? "GET" : (String)exampleResource.getSupportedOperations().iterator().next());
        }
        URL res = ObjCDeploymentModule.class.getResource(resource);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        try {
            this.processTemplate(res, model, out);
            out.flush();
            bytes.flush();
            return bytes.toString("utf-8");
        }
        catch (TemplateException e) {
            throw new EnunciateException((Throwable)e);
        }
    }

    protected ObjectWrapper getObjectWrapper() {
        return new DefaultObjectWrapper(){

            public TemplateModel wrap(Object obj) throws TemplateModelException {
                if (obj instanceof JavaDoc) {
                    return new FreemarkerJavaDoc((JavaDoc)obj);
                }
                return super.wrap(obj);
            }
        };
    }

    protected URL getTemplateURL(String template) {
        return ObjCDeploymentModule.class.getResource(template);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Map<String, String> getPackageIdentifiers() {
        return this.packageIdentifiers;
    }

    public void addPackageIdentifier(PackageIdentifier conversion) {
        String name = conversion.getName();
        String identifier = conversion.getIdentifier();
        if (name == null) {
            throw new IllegalArgumentException("A 'name' attribute must be specified on a 'package' element.");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("An 'identifer' attribute must be specified on 'package' element.");
        }
        this.packageIdentifiers.put(name, identifier);
    }

    public String getPackageIdentifierPattern() {
        return this.packageIdentifierPattern;
    }

    public void setPackageIdentifierPattern(String packageIdentifierPattern) {
        this.packageIdentifierPattern = packageIdentifierPattern;
    }

    public String getTypeDefinitionNamePattern() {
        return this.typeDefinitionNamePattern;
    }

    public void setTypeDefinitionNamePattern(String typeDefinitionNamePattern) {
        this.typeDefinitionNamePattern = typeDefinitionNamePattern;
    }

    public String getEnumConstantNamePattern() {
        return this.enumConstantNamePattern;
    }

    public void setEnumConstantNamePattern(String enumConstantNamePattern) {
        this.enumConstantNamePattern = enumConstantNamePattern;
    }

    public boolean isForceEnable() {
        return this.forceEnable;
    }

    public void setForceEnable(boolean forceEnable) {
        this.forceEnable = forceEnable;
    }

    public RuleSet getConfigurationRules() {
        return new ObjCRuleSet();
    }

    public Validator getValidator() {
        return new ObjCValidator();
    }

    public boolean isDisabled() {
        if (this.isForceEnable()) {
            this.debug("Objective C module is force-enabled via the 'require' attribute in the configuration.", new Object[0]);
            return false;
        }
        if (super.isDisabled()) {
            return true;
        }
        if (this.getModelInternal() != null && this.getModelInternal().getNamespacesToSchemas().isEmpty()) {
            this.debug("Objective C module is disabled because there are no schema types.", new Object[0]);
            return true;
        }
        if (this.getModelInternal() != null && this.getModelInternal().getRootResources().isEmpty() && this.getModelInternal().getRESTEndpoints().isEmpty()) {
            this.debug("Objective C module is disabled because there are no REST resources.", new Object[0]);
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ExtensionDepthComparator
    implements Comparator<TypeDefinition> {
        private ExtensionDepthComparator() {
        }

        @Override
        public int compare(TypeDefinition t1, TypeDefinition t2) {
            int depth1 = 0;
            int depth2 = 0;
            ClassType superClass = t1.getSuperclass();
            while (superClass != null && superClass.getDeclaration() != null && !Object.class.getName().equals(superClass.getDeclaration().getQualifiedName())) {
                ++depth1;
                superClass = superClass.getDeclaration().getSuperclass();
            }
            superClass = t2.getSuperclass();
            while (superClass != null && superClass.getDeclaration() != null && !Object.class.getName().equals(superClass.getDeclaration().getQualifiedName())) {
                ++depth2;
                superClass = superClass.getDeclaration().getSuperclass();
            }
            return depth1 - depth2;
        }
    }
}

