/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.objc;

import com.sun.mirror.declaration.PackageDeclaration;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.beans.Introspector;
import java.util.List;
import java.util.Map;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.modules.objc.ObjCDeploymentModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameForTypeDefinitionMethod
implements TemplateMethodModelEx {
    private final String pattern;
    private final String projectLabel;
    private final Map<String, String> namespaces2ids;
    private final Map<String, String> packages2ids;

    public NameForTypeDefinitionMethod(String pattern, String projectLabel, Map<String, String> namespaces2ids, Map<String, String> packages2ids) {
        this.pattern = pattern;
        this.packages2ids = packages2ids;
        this.projectLabel = ObjCDeploymentModule.scrubIdentifier(projectLabel);
        this.namespaces2ids = namespaces2ids;
    }

    public Object exec(List list) throws TemplateModelException {
        if (list.size() < 1) {
            throw new TemplateModelException("The nameForTypeDefinition method must have a type definition as a parameter.");
        }
        TemplateModel from = (TemplateModel)list.get(0);
        Object unwrapped = BeansWrapper.getDefaultInstance().unwrap(from);
        if (!(unwrapped instanceof TypeDefinition)) {
            throw new TemplateModelException("The nameForTypeDefinition method must have a type definition as a parameter.");
        }
        return this.calculateName((TypeDefinition)unwrapped);
    }

    public Object calculateName(TypeDefinition typeDefinition) {
        PackageDeclaration pckg;
        String name = ObjCDeploymentModule.scrubIdentifier(typeDefinition.getName());
        String simpleName = ObjCDeploymentModule.scrubIdentifier(typeDefinition.getSimpleName());
        String clientName = ObjCDeploymentModule.scrubIdentifier(typeDefinition.getClientSimpleName());
        String simpleNameDecap = ObjCDeploymentModule.scrubIdentifier(Introspector.decapitalize(simpleName));
        String clientNameDecap = ObjCDeploymentModule.scrubIdentifier(Introspector.decapitalize(clientName));
        if (name == null) {
            name = "anonymous_" + clientNameDecap;
        }
        String packageName = (pckg = typeDefinition.getPackage()) == null ? "" : pckg.getQualifiedName();
        String packageIdentifier = this.packages2ids.containsKey(packageName) ? ObjCDeploymentModule.scrubIdentifier(this.packages2ids.get(packageName)) : ObjCDeploymentModule.scrubIdentifier(packageName);
        String nsid = ObjCDeploymentModule.scrubIdentifier(this.namespaces2ids.get(typeDefinition.getNamespace()));
        return String.format(this.pattern, this.projectLabel, nsid, name, clientName, clientNameDecap, simpleName, simpleNameDecap, packageIdentifier);
    }
}

