/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.objc;

import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.declaration.PackageDeclaration;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.beans.Introspector;
import java.util.List;
import java.util.Map;
import org.codehaus.enunciate.ClientName;
import org.codehaus.enunciate.contract.jaxb.EnumTypeDefinition;
import org.codehaus.enunciate.modules.objc.ObjCDeploymentModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameForEnumConstantMethod
implements TemplateMethodModelEx {
    private final String pattern;
    private final String projectLabel;
    private final Map<String, String> namespaces2ids;
    private final Map<String, String> packages2ids;

    public NameForEnumConstantMethod(String pattern, String projectLabel, Map<String, String> namespaces2ids, Map<String, String> packages2ids) {
        this.pattern = pattern;
        this.packages2ids = packages2ids;
        this.projectLabel = ObjCDeploymentModule.scrubIdentifier(projectLabel);
        this.namespaces2ids = namespaces2ids;
    }

    public Object exec(List list) throws TemplateModelException {
        PackageDeclaration pckg;
        if (list.size() < 2) {
            throw new TemplateModelException("The nameForEnumConstant method must have an enum type definition and an enum constant declaration as parameters.");
        }
        Object unwrapped = BeansWrapper.getDefaultInstance().unwrap((TemplateModel)list.get(0));
        if (!(unwrapped instanceof EnumTypeDefinition)) {
            throw new TemplateModelException("The nameForEnumConstant method must have an enum type definition as a parameter.");
        }
        EnumTypeDefinition typeDefinition = (EnumTypeDefinition)unwrapped;
        unwrapped = BeansWrapper.getDefaultInstance().unwrap((TemplateModel)list.get(1));
        if (!(unwrapped instanceof EnumConstantDeclaration)) {
            throw new TemplateModelException("The nameForEnumConstant method must have an enum constant declaration as a parameter.");
        }
        EnumConstantDeclaration constant = (EnumConstantDeclaration)unwrapped;
        String name = ObjCDeploymentModule.scrubIdentifier(typeDefinition.getName());
        String simpleName = ObjCDeploymentModule.scrubIdentifier(typeDefinition.getSimpleName());
        String clientName = ObjCDeploymentModule.scrubIdentifier(typeDefinition.getClientSimpleName());
        String simpleNameDecap = ObjCDeploymentModule.scrubIdentifier(Introspector.decapitalize(simpleName));
        String clientNameDecap = ObjCDeploymentModule.scrubIdentifier(Introspector.decapitalize(clientName));
        if (name == null) {
            name = "anonymous_" + clientNameDecap;
        }
        String packageName = (pckg = typeDefinition.getPackage()) == null ? "" : pckg.getQualifiedName();
        String packageIdentifier = this.packages2ids.containsKey(packageName) ? ObjCDeploymentModule.scrubIdentifier(this.packages2ids.get(packageName)) : ObjCDeploymentModule.scrubIdentifier(packageName);
        String nsid = ObjCDeploymentModule.scrubIdentifier(this.namespaces2ids.get(typeDefinition.getNamespace()));
        String constantName = ObjCDeploymentModule.scrubIdentifier(constant.getSimpleName());
        String constantClientName = ObjCDeploymentModule.scrubIdentifier(constant.getAnnotation(ClientName.class) != null ? ((ClientName)constant.getAnnotation(ClientName.class)).value() : constantName);
        return String.format(this.pattern, this.projectLabel, nsid, name, clientName, clientNameDecap, simpleName, simpleNameDecap, packageIdentifier, constantClientName, constantName);
    }
}

