/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.objc;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import freemarker.template.TemplateModelException;
import java.awt.Image;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import org.codehaus.enunciate.contract.jaxb.Accessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientClassnameForMethod
extends org.codehaus.enunciate.template.freemarker.ClientClassnameForMethod {
    private final Map<String, String> classConversions = new HashMap<String, String>();

    public ClientClassnameForMethod(Map<String, String> conversions) {
        super(conversions);
        this.setJdk15(false);
        this.classConversions.put(Boolean.class.getName(), "BOOL");
        this.classConversions.put(String.class.getName(), "NSString");
        this.classConversions.put(Integer.class.getName(), "int");
        this.classConversions.put(Short.class.getName(), "short");
        this.classConversions.put(Byte.class.getName(), "unsigned char");
        this.classConversions.put(Double.class.getName(), "double");
        this.classConversions.put(Long.class.getName(), "long");
        this.classConversions.put(BigInteger.class.getName(), "NSNumber");
        this.classConversions.put(BigDecimal.class.getName(), "NSDecimalNumber");
        this.classConversions.put(Float.class.getName(), "float");
        this.classConversions.put(Character.class.getName(), "xmlChar");
        this.classConversions.put(Date.class.getName(), "NSDate");
        this.classConversions.put(DataHandler.class.getName(), "NSData");
        this.classConversions.put(Image.class.getName(), "NSData");
        this.classConversions.put(Source.class.getName(), "NSData");
        this.classConversions.put(QName.class.getName(), "NSString");
        this.classConversions.put(URI.class.getName(), "NSURL");
        this.classConversions.put(UUID.class.getName(), "NSString");
        this.classConversions.put(XMLGregorianCalendar.class.getName(), "NSCalendarDate");
        this.classConversions.put(GregorianCalendar.class.getName(), "NSCalendarDate");
        this.classConversions.put(Calendar.class.getName(), "NSCalendarDate");
        this.classConversions.put(Duration.class.getName(), "NSString");
        this.classConversions.put(JAXBElement.class.getName(), "JAXBBasicXMLNode");
        this.classConversions.put(Object.class.getName(), "NSObject");
        this.classConversions.putAll(conversions);
    }

    public String convert(TypeDeclaration declaration) throws TemplateModelException {
        String fqn = declaration.getQualifiedName();
        if (this.classConversions.containsKey(fqn)) {
            return this.classConversions.get(fqn);
        }
        if (this.isCollection(declaration)) {
            return "NSArray";
        }
        return super.convert(declaration);
    }

    protected boolean isCollection(TypeDeclaration declaration) {
        DecoratedTypeMirror decorated;
        String fqn = declaration.getQualifiedName();
        if (Collection.class.getName().equals(fqn)) {
            return true;
        }
        if (Object.class.getName().equals(fqn)) {
            return false;
        }
        if (declaration instanceof ClassDeclaration && (decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)((ClassDeclaration)declaration).getSuperclass())).isCollection()) {
            return true;
        }
        for (InterfaceType interfaceType : declaration.getSuperinterfaces()) {
            DecoratedTypeMirror decorated2 = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)interfaceType);
            if (!decorated2.isCollection()) continue;
            return true;
        }
        return false;
    }

    public String convert(Accessor accessor) throws TemplateModelException {
        if (accessor.isXmlList()) {
            return "NSString";
        }
        if (accessor.isXmlIDREF() && !accessor.isCollectionType()) {
            return "NSString";
        }
        return super.convert(accessor);
    }

    public String convert(TypeMirror typeMirror) throws TemplateModelException {
        DecoratedTypeMirror decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)typeMirror);
        if (decorated.isPrimitive()) {
            PrimitiveType.Kind kind = ((PrimitiveType)decorated).getKind();
            switch (kind) {
                case BOOLEAN: {
                    return "BOOL";
                }
                case BYTE: {
                    return "unsigned char";
                }
                case INT: {
                    return "int";
                }
                case SHORT: {
                    return "short";
                }
                case FLOAT: {
                    return "float";
                }
                case DOUBLE: {
                    return "double";
                }
                case LONG: {
                    return "long";
                }
            }
            return "NSString";
        }
        if (decorated.isCollection()) {
            return "NSArray";
        }
        if (decorated.isArray()) {
            TypeMirror componentType = ((ArrayType)decorated).getComponentType();
            if (componentType instanceof PrimitiveType && ((PrimitiveType)componentType).getKind() == PrimitiveType.Kind.BYTE) {
                return "NSData";
            }
            return "NSArray";
        }
        return super.convert(typeMirror);
    }
}

